/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.CloudState;
import org.eclipse.gyrex.cloud.internal.NodeEnvironmentImpl;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.locking.ZooKeeperLockService;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueueService;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudActivator
extends BaseBundleActivator {
    static final Logger LOG = LoggerFactory.getLogger(CloudActivator.class);
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.cloud";
    private static final AtomicReference<CloudActivator> instanceRef = new AtomicReference();
    private final AtomicReference<IServiceProxy<Location>> instanceLocationServiceRef = new AtomicReference();
    private final AtomicReference<IServiceProxy<IPreferencesService>> preferenceServiceRef = new AtomicReference();
    private final AtomicReference<IServiceProxy<EventAdmin>> eventAdminRef = new AtomicReference();
    private volatile NodeEnvironmentImpl nodeEnvironment;
    private ServiceRegistration<IQueueService> queueServiceRegistration;
    private ServiceRegistration<ILockService> lockServiceRegistration;

    public static CloudActivator getInstance() {
        CloudActivator instance = instanceRef.get();
        if (instance == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Bundle {0} is not active.", (Object)SYMBOLIC_NAME));
        }
        return instance;
    }

    public CloudActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instanceRef.set(this);
        String nodeId = new NodeInfo().getNodeId();
        LOG.info("Node id: {}", (Object)nodeId);
        this.instanceLocationServiceRef.set((IServiceProxy<Location>)this.getServiceHelper().trackService(Location.class, context.createFilter(Location.INSTANCE_FILTER)));
        this.preferenceServiceRef.set((IServiceProxy<IPreferencesService>)this.getServiceHelper().trackService(IPreferencesService.class));
        this.eventAdminRef.set((IServiceProxy<EventAdmin>)this.getServiceHelper().trackService(EventAdmin.class));
        this.nodeEnvironment = new NodeEnvironmentImpl();
        this.getServiceHelper().registerService(INodeEnvironment.SERVICE_NAME, (Object)this.nodeEnvironment, "Eclipse Gyrex", "Node environment service.", null, null);
        CloudState.registerNode();
    }

    protected void doStop(BundleContext context) throws Exception {
        CloudState.unregisterNode();
        this.nodeEnvironment = null;
        this.lockServiceRegistration = null;
        this.queueServiceRegistration = null;
        instanceRef.set(null);
        this.instanceLocationServiceRef.set(null);
        this.preferenceServiceRef.set(null);
        this.eventAdminRef.set(null);
    }

    protected Class getDebugOptions() {
        return CloudDebug.class;
    }

    public EventAdmin getEventAdmin() {
        IServiceProxy<EventAdmin> serviceProxy = this.eventAdminRef.get();
        if (serviceProxy == null) {
            throw this.createBundleInactiveException();
        }
        return (EventAdmin)serviceProxy.getService();
    }

    public INodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public IPreferencesService getPreferenceService() {
        IServiceProxy<IPreferencesService> serviceProxy = this.preferenceServiceRef.get();
        if (serviceProxy == null) {
            throw this.createBundleInactiveException();
        }
        return (IPreferencesService)serviceProxy.getService();
    }

    void startCloudServices() {
        if (CloudDebug.debug) {
            LOG.debug("Starting cloud services");
        }
        this.lockServiceRegistration = this.getServiceHelper().registerService(ILockService.class, (Object)new ZooKeeperLockService(), "Eclipse Gyrex", "ZooKeeper base lock service.", null, null);
        this.queueServiceRegistration = this.getServiceHelper().registerService(IQueueService.class, (Object)new ZooKeeperQueueService(), "Eclipse Gyrex", "ZooKeeper base queue service.", null, null);
    }

    void stopCloudServices() {
        ServiceRegistration<IQueueService> queueServiceRegistration;
        ServiceRegistration<ILockService> lockServiceRegistration;
        if (CloudDebug.debug) {
            LOG.debug("Stopping cloud services");
        }
        if ((lockServiceRegistration = this.lockServiceRegistration) != null) {
            lockServiceRegistration.unregister();
            this.lockServiceRegistration = null;
        }
        if ((queueServiceRegistration = this.queueServiceRegistration) != null) {
            queueServiceRegistration.unregister();
            this.queueServiceRegistration = null;
        }
    }
}

