/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.gyrex.cloud.internal.CloudState;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class CloudConsoleCommands
implements CommandProvider {
    static final String APPROVED = "approved";
    static final String PENDING = "pending";
    static final Map<String, Command> cloudCommands = new TreeMap<String, Command>();
    private ICloudManager cloudManager;

    static {
        cloudCommands.put("ls", new Command("pending|approved"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                String a1 = ci.nextArgument();
                Collection<INodeDescriptor> nodes = null;
                if (StringUtils.startsWith((String)CloudConsoleCommands.APPROVED, (String)a1)) {
                    nodes = cloudManager.getApprovedNodes();
                } else if (StringUtils.startsWith((String)CloudConsoleCommands.PENDING, (String)a1)) {
                    nodes = cloudManager.getPendingNodes();
                }
                if (nodes == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                String filter = ci.nextArgument();
                for (INodeDescriptor node : nodes) {
                    if (!CloudConsoleCommands.matchesFilter(filter, node)) continue;
                    StringBuilder nodeInfo = new StringBuilder();
                    nodeInfo.append("Node ");
                    nodeInfo.append(node.getName());
                    nodeInfo.append(" (");
                    nodeInfo.append(node.getId());
                    nodeInfo.append(" @ ");
                    nodeInfo.append(node.getLocation());
                    if (node.getTags().size() > 0) {
                        nodeInfo.append("; ").append(StringUtils.join(node.getTags(), (String)", "));
                    }
                    nodeInfo.append(")");
                    ci.println((Object)nodeInfo.toString());
                }
            }
        });
        cloudCommands.put("approve", new Command("nodeId"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                String nodeId = ci.nextArgument();
                if (nodeId == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                IStatus status = cloudManager.approveNode(nodeId);
                if (status.isOK()) {
                    ci.println((Object)("Node " + nodeId + " approved!"));
                } else {
                    ci.println((Object)status.getMessage());
                }
            }
        });
        cloudCommands.put("retire", new Command("nodeId"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                String nodeId = ci.nextArgument();
                if (nodeId == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                IStatus status = cloudManager.retireNode(nodeId);
                if (status.isOK()) {
                    ci.println((Object)("Node " + nodeId + " retired!"));
                } else {
                    ci.println((Object)status.getMessage());
                }
            }
        });
        cloudCommands.put("setConnectString", new Command("connectString"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                String connectString = ci.nextArgument();
                if (connectString == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                IStatus status = cloudManager.getNodeConfigurer(new NodeInfo().getNodeId()).configureConnection(connectString);
                if (status.isOK()) {
                    ci.println((Object)("Node cloud connection updated to " + connectString + "!"));
                } else {
                    ci.println((Object)status.getMessage());
                }
            }
        });
        cloudCommands.put("setTags", new Command("<nodeId> [<tag[,tag...]>]"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                IStatus status;
                String nodeId = ci.nextArgument();
                if (nodeId == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                HashSet<String> tags = null;
                String[] rolesArg = StringUtils.split((String)ci.nextArgument(), (char)',');
                if (rolesArg != null) {
                    tags = new HashSet<String>();
                    int i = 0;
                    while (i < rolesArg.length) {
                        String role = StringUtils.trimToNull((String)rolesArg[i]);
                        if (role != null && !tags.contains(role)) {
                            tags.add(role);
                        }
                        ++i;
                    }
                }
                if ((status = cloudManager.getNodeConfigurer(nodeId).setTags(tags)).isOK()) {
                    if (tags != null) {
                        ci.println((Object)("Tags of node " + nodeId + " updated to " + StringUtils.join(tags, (char)',') + "!"));
                    } else {
                        ci.println((Object)("Tags of node " + nodeId + " has been reset!"));
                    }
                } else {
                    ci.println((Object)status.getMessage());
                }
            }
        });
        cloudCommands.put("setOffline", new Command("sets the current node off-line"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                CloudState.unregisterNode();
                ci.println((Object)"Node unregistered from cloud!");
            }
        });
        cloudCommands.put("setOnline", new Command("sets the current node on-line"){

            @Override
            public void execute(ICloudManager cloudManager, CommandInterpreter ci) throws Exception {
                CloudState.registerNode();
                ci.println((Object)"Node registered with cloud!");
            }
        });
    }

    static void _cloudHelp(CommandInterpreter ci) {
        ci.println((Object)"cloud <cmd> [args]");
        for (String cmd : cloudCommands.keySet()) {
            ci.println((Object)("\t" + cmd + " " + cloudCommands.get(cmd).getHelp()));
        }
    }

    static boolean matchesFilter(String filter, INodeDescriptor node) {
        return filter == null || StringUtils.containsIgnoreCase((String)node.getId(), (String)filter) || StringUtils.containsIgnoreCase((String)node.getName(), (String)filter) || StringUtils.containsIgnoreCase((String)node.getLocation(), (String)filter);
    }

    public void _cloud(CommandInterpreter ci) throws Exception {
        String command = ci.nextArgument();
        if (command == null) {
            CloudConsoleCommands._cloudHelp(ci);
            return;
        }
        Command cmd = cloudCommands.get(command);
        if (cmd == null) {
            ci.println((Object)("ERROR: unknown ZooKeeper command " + command));
            CloudConsoleCommands._cloudHelp(ci);
            return;
        }
        ICloudManager cloudManager = null;
        try {
            cloudManager = this.getCloudManager();
        }
        catch (Exception e) {
            ci.println((Object)("ZooKeeper not connected! " + e.getMessage()));
            return;
        }
        cmd.execute(cloudManager, ci);
    }

    public ICloudManager getCloudManager() {
        ICloudManager manager = this.cloudManager;
        if (manager == null) {
            throw new IllegalStateException("cloud manager not available");
        }
        return manager;
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.appendln("---Cloud Commands---");
        help.appendln("\tcloud <cmd> [args]");
        for (String cmd : cloudCommands.keySet()) {
            help.appendln("\t\t" + cmd + " " + cloudCommands.get(cmd).getHelp());
        }
        return help.toString();
    }

    public void setCloudManager(ICloudManager cloudManager) {
        this.cloudManager = cloudManager;
    }

    static abstract class Command {
        private final String help;

        public Command(String help) {
            this.help = help;
        }

        public abstract void execute(ICloudManager var1, CommandInterpreter var2) throws Exception;

        public String getHelp() {
            return this.help;
        }

        protected void printInvalidArgs(CommandInterpreter ci) {
            ci.println((Object)"ERROR: invalid arguments");
            ci.println((Object)("\t" + this.getHelp()));
        }
    }
}

