/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EquinoxApplicationLauncher
extends ServiceTracker<ApplicationDescriptor, ApplicationDescriptor> {
    private static final Logger LOG = LoggerFactory.getLogger(EquinoxApplicationLauncher.class);
    private final String applicationExtensionId;
    private ApplicationHandle runingApp;

    public EquinoxApplicationLauncher(BundleContext context, String applicationExtensionId) throws InvalidSyntaxException {
        super(context, context.createFilter(NLS.bind((String)"(&(objectClass={0})(service.pid={1}))", (Object)ApplicationDescriptor.class.getName(), (Object)applicationExtensionId)), null);
        this.applicationExtensionId = applicationExtensionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationDescriptor addingService(ServiceReference<ApplicationDescriptor> reference) {
        ApplicationDescriptor appDescriptor = (ApplicationDescriptor)super.addingService(reference);
        try {
            EquinoxApplicationLauncher equinoxApplicationLauncher = this;
            synchronized (equinoxApplicationLauncher) {
                if (this.runingApp == null) {
                    this.runingApp = appDescriptor.launch(null);
                }
            }
        }
        catch (ApplicationException e) {
            LOG.error("Error starting application {}! {}", (Object)this.applicationExtensionId, (Object)e.getMessage());
        }
        return appDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<ApplicationDescriptor> reference, ApplicationDescriptor service) {
        EquinoxApplicationLauncher equinoxApplicationLauncher = this;
        synchronized (equinoxApplicationLauncher) {
            if (this.runingApp != null && this.runingApp.getApplicationDescriptor() == service) {
                this.runingApp.destroy();
                this.runingApp = null;
            }
        }
        super.removedService(reference, (Object)service);
    }
}

