/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.queue;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.gyrex.cloud.internal.queue.QueueOperationFailedException;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueue;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.services.queue.IMessage;

public class Message
implements IMessage {
    private final String queueId;
    private final byte[] body;
    private int zkNodeDataVersion;
    private long invisibleTimeoutTS;
    private final String messageId;
    private final ZooKeeperQueue zooKeeperQueue;

    public Message(String queueId, byte[] body) {
        this.messageId = null;
        this.zooKeeperQueue = null;
        this.queueId = queueId;
        this.body = body;
        this.zkNodeDataVersion = -1;
        this.invisibleTimeoutTS = 0L;
    }

    public Message(String messageId, ZooKeeperQueue zooKeeperQueue, byte[] record, Stat stat) throws IOException {
        this.messageId = messageId;
        this.zooKeeperQueue = zooKeeperQueue;
        this.queueId = zooKeeperQueue.id;
        this.zkNodeDataVersion = stat.getVersion();
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(record));
        int formatVersion = din.readInt();
        if (formatVersion != 1) {
            throw new IllegalArgumentException(String.format("invalid record data: version mismatch (expected %d, found %d)", 1, formatVersion));
        }
        this.invisibleTimeoutTS = din.readLong();
        int length = din.readInt();
        this.body = new byte[length];
        int read = din.read(this.body);
        if (read != length) {
            throw new IllegalArgumentException(String.format("invalid record data: body size mismatch (expected %d, read %d)", length, read));
        }
    }

    public boolean consume(boolean failIfDeleted) throws NoSuchElementException {
        if (!this.receive(1000L, failIfDeleted)) {
            return false;
        }
        return this.delete(failIfDeleted);
    }

    public boolean delete(boolean failIfDeleted) throws NoSuchElementException {
        try {
            ZooKeeperGate.get().deletePath(this.zooKeeperQueue.queuePath.append(this.messageId), this.zkNodeDataVersion);
            return true;
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                if (failIfDeleted) {
                    throw new NoSuchElementException("Message does not exists!");
                }
                return true;
            }
            if (e instanceof KeeperException.BadVersionException) {
                return false;
            }
            throw new QueueOperationFailedException(this.queueId, String.format("DELETE_MESSAGE(%s)", this.messageId), e);
        }
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }

    public boolean isHidden() {
        return this.invisibleTimeoutTS >= System.currentTimeMillis();
    }

    public boolean receive(long timeoutInMs, boolean failIfDeleted) throws NoSuchElementException {
        this.invisibleTimeoutTS = timeoutInMs + System.currentTimeMillis();
        try {
            Stat stat = ZooKeeperGate.get().writeRecord(this.zooKeeperQueue.queuePath.append(this.messageId), this.toByteArray(), this.zkNodeDataVersion);
            this.zkNodeDataVersion = stat.getVersion();
            return true;
        }
        catch (Exception e) {
            this.invisibleTimeoutTS = 0L;
            if (e instanceof KeeperException.NoNodeException) {
                if (failIfDeleted) {
                    throw new NoSuchElementException("Message does not exists!");
                }
                return false;
            }
            if (e instanceof KeeperException.BadVersionException) {
                return false;
            }
            throw new QueueOperationFailedException(this.queueId, String.format("RECEIVE_MESSAGE(%s)", this.messageId), e);
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)bos);
        dos.writeInt(1);
        dos.writeLong(this.invisibleTimeoutTS);
        dos.writeInt(this.body.length);
        dos.write(this.body);
        return bos.toByteArray();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Message [messageId=").append(this.messageId).append(", queueId=").append(this.queueId).append(", invisibleTill=").append(this.invisibleTimeoutTS > 0L ? DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.format(this.invisibleTimeoutTS) : "0").append(", version=").append(this.zkNodeDataVersion).append("]");
        return builder.toString();
    }
}

