/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.debug;

import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BundleDebugOptions {
    private static final Logger LOG = LoggerFactory.getLogger(BundleDebugOptions.class);
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;

    public static void initializeDebugOptions(BaseBundleActivator bundleActivator, Class clazz) {
        BundleContext context = bundleActivator.getBundle().getBundleContext();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", bundleActivator.getSymbolicName());
        ((Dictionary)props).put("service.vendor", "Eclipse Gyrex Project");
        ((Dictionary)props).put("service.description", "Debug options listener.");
        BundleDebugOptionsListener debugOptionsListener = new BundleDebugOptionsListener(bundleActivator, clazz);
        context.registerService(DebugOptionsListener.class.getName(), (Object)debugOptionsListener, props);
        bundleActivator.addShutdownParticipant(debugOptionsListener);
    }

    static void loadDebugOptions(BaseBundleActivator bundleActivator, Class clazz, DebugOptions debugOptions) {
        Field[] fieldArray;
        String symbolicName = bundleActivator.getSymbolicName();
        boolean isDebug = debugOptions.getBooleanOption(String.valueOf(symbolicName) + "/debug", false);
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if ((field.getModifiers() & 0x19) == 9) {
                try {
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    String key = String.valueOf(symbolicName) + "/" + field.getName();
                    if (field.getType() == Boolean.TYPE) {
                        field.set(null, new Boolean(isDebug && debugOptions.getBooleanOption(key, false)));
                    } else if (field.getType() == String.class) {
                        String value = debugOptions.getOption(key);
                        if (field.getName().equals("debugPrefix")) {
                            int lastDot = symbolicName.lastIndexOf(46);
                            value = lastDot != -1 ? symbolicName.substring(lastDot) : symbolicName;
                        }
                        field.set(null, value != null ? value : "");
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception setting debug option \"{}\" in class \"{}\": {}", new Object[]{field.getName(), clazz.getName(), e.getMessage()});
                }
            }
            ++n2;
        }
    }

    static final class BundleDebugOptionsListener
    implements DebugOptionsListener,
    IShutdownParticipant {
        private BaseBundleActivator bundleActivator;
        private Class bundleDebugClass;

        public BundleDebugOptionsListener(BaseBundleActivator bundleActivator, Class bundleDebugClass) {
            this.bundleActivator = bundleActivator;
            this.bundleDebugClass = bundleDebugClass;
        }

        public void optionsChanged(DebugOptions options) {
            BaseBundleActivator bundleActivator = this.bundleActivator;
            Class clazz = this.bundleDebugClass;
            if (bundleActivator != null && clazz != null) {
                BundleDebugOptions.loadDebugOptions(bundleActivator, clazz, options);
            }
        }

        @Override
        public void shutdown() throws Exception {
            this.bundleActivator = null;
            this.bundleDebugClass = null;
        }
    }
}

