/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.manager.ContextManagerImpl;
import org.eclipse.gyrex.context.internal.provider.ObjectProviderRegistry;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.manager.IRuntimeContextManager;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ContextActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.context";
    private static final AtomicReference<ContextActivator> instanceRef = new AtomicReference();
    private final AtomicReference<IServiceProxy<IPreferencesService>> preferencesServiceProxyRef = new AtomicReference();
    private final AtomicReference<ContextRegistryImpl> contextRegistryRef = new AtomicReference();

    public static ContextActivator getInstance() {
        ContextActivator contextActivator = instanceRef.get();
        if (contextActivator == null) {
            throw new IllegalStateException(NLS.bind((String)"The Gyrex contextual runtime bundle {0} is inactive.", (Object)SYMBOLIC_NAME));
        }
        return contextActivator;
    }

    public ContextActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instanceRef.set(this);
        this.preferencesServiceProxyRef.set((IServiceProxy<IPreferencesService>)this.getServiceHelper().trackService(IPreferencesService.class));
        ObjectProviderRegistry objectProviderRegistry = new ObjectProviderRegistry();
        objectProviderRegistry.start(context);
        this.addShutdownParticipant(objectProviderRegistry);
        ContextRegistryImpl contextRegistry = new ContextRegistryImpl(objectProviderRegistry);
        this.getServiceHelper().registerService(IRuntimeContextRegistry.class.getName(), (Object)contextRegistry, "Eclipse.org Gyrex", "Eclipse Gyrex Contextual Runtime Registry", null, null);
        this.contextRegistryRef.set(contextRegistry);
        ContextManagerImpl contextManager = new ContextManagerImpl(contextRegistry);
        this.getServiceHelper().registerService(IRuntimeContextManager.class.getName(), (Object)contextManager, "Eclipse.org Gyrex", "Eclipse Gyrex Contextual Runtime Manager", null, null);
        this.addShutdownParticipant(contextManager);
    }

    protected void doStop(BundleContext context) throws Exception {
        instanceRef.set(null);
        this.preferencesServiceProxyRef.set(null);
        ContextRegistryImpl contextRegistry = this.contextRegistryRef.getAndSet(null);
        if (contextRegistry != null) {
            contextRegistry.close();
        }
    }

    public ContextRegistryImpl getContextRegistryImpl() {
        return this.contextRegistryRef.get();
    }

    protected Class getDebugOptions() {
        return ContextDebug.class;
    }

    public IPreferencesService getPreferencesService() {
        IServiceProxy<IPreferencesService> serviceProxy = this.preferencesServiceProxyRef.get();
        if (serviceProxy == null) {
            throw this.createBundleInactiveException();
        }
        return (IPreferencesService)serviceProxy.getService();
    }
}

