/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.gyrex.context.di.IRuntimeContextInjector;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.GyrexContextObject;
import org.eclipse.gyrex.context.internal.di.GyrexContextInjectorImpl;
import org.eclipse.gyrex.context.internal.preferences.GyrexContextPreferencesImpl;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.preferences.IRuntimeContextPreferences;

public class GyrexContextImpl
extends PlatformObject
implements IDisposable {
    static final String ECLIPSE_CONTEXT_KEY = GyrexContextImpl.class.getName();
    private final IPath contextPath;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final ContextRegistryImpl contextRegistry;
    private final Set<IDisposable> disposables = new CopyOnWriteArraySet<IDisposable>();
    private final GyrexContextInjectorImpl injector;
    private final GyrexContextPreferencesImpl preferences;
    private final AtomicLong lastAccessTime = new AtomicLong();
    private final ConcurrentMap<Class<?>, GyrexContextObject> computedObjects = new ConcurrentHashMap();

    private static <T> T safeCast(Object object) {
        try {
            return (T)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public GyrexContextImpl(IPath contextPath, ContextRegistryImpl contextRegistry) {
        if (contextPath == null) {
            throw new IllegalArgumentException("context path may not be null");
        }
        if (contextRegistry == null) {
            throw new IllegalArgumentException("context registry may not be null");
        }
        this.contextPath = contextPath;
        this.contextRegistry = contextRegistry;
        this.injector = new GyrexContextInjectorImpl(this);
        this.preferences = new GyrexContextPreferencesImpl(contextRegistry.getHandle(contextPath));
    }

    public void addDisposable(IDisposable disposable) {
        this.checkDisposed();
        if (!this.disposables.contains(disposable)) {
            this.disposables.add(disposable);
        }
    }

    private void checkDisposed() throws IllegalStateException {
        if (this.disposed.get()) {
            throw new IllegalStateException("context is disposed");
        }
    }

    public void dispose() {
        if (this.disposed.getAndSet(true)) {
            return;
        }
        if (this.injector instanceof IDisposable) {
            ((IDisposable)this.injector).dispose();
        }
        this.preferences.dispose();
        for (IDisposable disposable : this.disposables) {
            disposable.dispose();
        }
        this.disposables.clear();
    }

    public <T> T get(Class<T> type) throws IllegalArgumentException {
        this.checkDisposed();
        this.trackAccess();
        GyrexContextObject contextObject = (GyrexContextObject)this.computedObjects.get(type);
        if (contextObject == null) {
            this.computedObjects.putIfAbsent(type, new GyrexContextObject(this, type));
            contextObject = (GyrexContextObject)this.computedObjects.get(type);
        }
        return GyrexContextImpl.safeCast(contextObject.compute());
    }

    public IPath getContextPath() {
        this.trackAccess();
        return this.contextPath;
    }

    ContextRegistryImpl getContextRegistry() {
        this.checkDisposed();
        return this.contextRegistry;
    }

    public GyrexContextHandle getHandle() {
        return this.contextRegistry.getHandle(this.contextPath);
    }

    public IRuntimeContextInjector getInjector() {
        this.checkDisposed();
        return this.injector;
    }

    long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public IRuntimeContextPreferences getPreferences() {
        return this.preferences;
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    void removeDisposable(IDisposable disposable) {
        if (!this.disposed.get()) {
            this.disposables.remove(disposable);
        }
    }

    public String toString() {
        return "Gyrex Context [" + this.contextPath.toString() + "]";
    }

    private void trackAccess() {
        this.lastAccessTime.set(System.currentTimeMillis());
    }
}

