/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.preferences;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.eclipse.gyrex.context.preferences.IRuntimeContextPreferences;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyrexContextPreferencesImpl
implements IRuntimeContextPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(GyrexContextPreferencesImpl.class);
    public static final String SETTINGS = ".settings";
    private static final String EMPTY = "";
    private static final String DEFAULT = "default";
    private static final String UTF_8 = "UTF-8";
    private volatile IRuntimeContext context;

    private static void appendIfPathExists(List<Preferences> result, Preferences parent, String pathName) {
        block6: {
            try {
                if (parent.nodeExists(pathName)) {
                    if (ContextDebug.preferencesLookup) {
                        LOG.debug("Adding node {}", (Object)parent.node(pathName).absolutePath());
                    }
                    result.add(parent.node(pathName));
                } else if (ContextDebug.preferencesLookup) {
                    LOG.debug("Ignoring node {} (does not exist)", (Object)(String.valueOf(parent.absolutePath()) + "/" + pathName));
                }
            }
            catch (BackingStoreException e) {
                if (!ContextDebug.preferencesLookup) break block6;
                LOG.debug("Ignoring node {} (has been removed {})", (Object)(String.valueOf(parent.absolutePath()) + "/" + pathName), (Object)e.getMessage());
            }
        }
    }

    public static Preferences getNode(String qualifier, String key, IRuntimeContext context) {
        if (context == null) {
            throw new IllegalStateException("context had been disposed");
        }
        String pathToPreferencesKey = GyrexContextPreferencesImpl.getPathToPreferencesKey(qualifier, key);
        IEclipsePreferences node = ContextConfiguration.getRootNodeForContextPreferences();
        IPath contextPath = context.getContextPath();
        if (!contextPath.isEmpty() && !contextPath.isRoot()) {
            return node.node(GyrexContextPreferencesImpl.getPreferencesPathToSettings(contextPath, pathToPreferencesKey));
        }
        return node.node(GyrexContextPreferencesImpl.getPreferencesPathToSettings((IPath)Path.ROOT, pathToPreferencesKey));
    }

    public static Preferences[] getNodes(String qualifier, String key, IRuntimeContext context) {
        if (context == null) {
            throw new IllegalStateException("context had been disposed");
        }
        if (ContextDebug.preferencesLookup) {
            LOG.debug("Preferences lookup for {}/{} in context {}", new Object[]{qualifier, key, context});
        }
        IEclipsePreferences rootNode = EclipsePreferencesUtil.getRootNode();
        String pathToPreferencesKey = GyrexContextPreferencesImpl.getPathToPreferencesKey(qualifier, key);
        ArrayList<Preferences> result = new ArrayList<Preferences>();
        Preferences platformPrefRoot = rootNode.node("cloud").node(ContextConfiguration.CONTEXT_PREF_ROOT.toString());
        IPath contextPath = context.getContextPath();
        while (!contextPath.isEmpty() && !contextPath.isRoot()) {
            GyrexContextPreferencesImpl.appendIfPathExists(result, platformPrefRoot, GyrexContextPreferencesImpl.getPreferencesPathToSettings(contextPath, pathToPreferencesKey));
            contextPath = contextPath.removeLastSegments(1);
        }
        GyrexContextPreferencesImpl.appendIfPathExists(result, platformPrefRoot, GyrexContextPreferencesImpl.getPreferencesPathToSettings((IPath)Path.ROOT, pathToPreferencesKey));
        GyrexContextPreferencesImpl.appendIfPathExists(result, rootNode.node(DEFAULT), pathToPreferencesKey);
        return result.isEmpty() ? null : result.toArray(new Preferences[result.size()]);
    }

    public static String getPathToPreferencesKey(String qualifier, String key) {
        return String.valueOf(EclipsePreferencesUtil.decodePath((String)qualifier)[1]) + '/' + EclipsePreferencesUtil.makeRelative((String)EclipsePreferencesUtil.decodePath((String)key)[0]);
    }

    public static String getPreferencesPathToSettings(IPath contextPath, String pathToPreferencesKey) {
        if (pathToPreferencesKey != null && pathToPreferencesKey.length() > 0) {
            return contextPath.append(SETTINGS).append(pathToPreferencesKey).makeRelative().toString();
        }
        return contextPath.append(SETTINGS).makeRelative().toString();
    }

    @Inject
    public GyrexContextPreferencesImpl(IRuntimeContext context) {
        this.context = context;
    }

    @PreDestroy
    public void dispose() {
        this.context = null;
    }

    @Override
    public void flush(String qualifier) throws BackingStoreException, SecurityException {
        if (ContextDebug.preferencesModify) {
            LOG.debug("Flushing preferences of context \"{}\" for qualifier \"{}\"", (Object)this.context, (Object)qualifier);
        }
        GyrexContextPreferencesImpl.getNode(qualifier, EMPTY, this.context).flush();
    }

    private String get(String key, String defaultValue, Preferences[] nodes) {
        return EclipsePreferencesUtil.getPreferencesService().get(EclipsePreferencesUtil.decodePath((String)key)[1], defaultValue, nodes);
    }

    @Override
    public String get(String qualifier, String key, String defaultValue) throws SecurityException {
        return this.get(key, defaultValue, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
    }

    @Override
    public boolean getBoolean(String qualifier, String key, boolean defaultValue) throws SecurityException {
        String result = this.get(key, null, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
        return result == null ? defaultValue : Boolean.valueOf(result);
    }

    @Override
    public byte[] getByteArray(String qualifier, String key, byte[] defaultValue) throws SecurityException {
        String result = this.get(key, null, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
        try {
            return result == null ? defaultValue : Base64.decodeBase64((byte[])result.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Gyrex requires a platform which supports UTF-8.", e);
        }
    }

    @Override
    public double getDouble(String qualifier, String key, double defaultValue) throws SecurityException {
        String value = this.get(key, null, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
        return NumberUtils.toDouble((String)value, (double)defaultValue);
    }

    @Override
    public float getFloat(String qualifier, String key, float defaultValue) throws SecurityException {
        String value = this.get(key, null, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
        return NumberUtils.toFloat((String)value, (float)defaultValue);
    }

    @Override
    public int getInt(String qualifier, String key, int defaultValue) throws SecurityException {
        String value = this.get(key, null, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    @Override
    public String[] getKeys(String qualifier) throws BackingStoreException, SecurityException {
        return GyrexContextPreferencesImpl.getNode(qualifier, EMPTY, this.context).keys();
    }

    @Override
    public long getLong(String qualifier, String key, long defaultValue) throws SecurityException {
        String value = this.get(key, null, GyrexContextPreferencesImpl.getNodes(qualifier, key, this.context));
        return NumberUtils.toLong((String)value, (long)defaultValue);
    }

    @Override
    public void put(String qualifier, String key, String value, boolean encrypt) throws SecurityException {
        if (value == null) {
            this.remove(qualifier, key);
        } else {
            this.put(qualifier, key, value, this.context, encrypt);
        }
    }

    private void put(String qualifier, String key, String value, IRuntimeContext context, boolean encrypt) {
        if (ContextDebug.preferencesModify) {
            LOG.debug("Preference modification in context \"{}\" for qualifier \"{}\": {}", new Object[]{context, qualifier, key});
        }
        GyrexContextPreferencesImpl.getNode(qualifier, key, context).put(EclipsePreferencesUtil.decodePath((String)key)[1], value);
    }

    @Override
    public void putBoolean(String qualifier, String key, boolean value, boolean encrypt) throws SecurityException {
        this.put(qualifier, key, Boolean.toString(value), this.context, encrypt);
    }

    @Override
    public void putByteArray(String qualifier, String key, byte[] value, boolean encrypt) throws SecurityException {
        if (value == null) {
            this.remove(qualifier, key);
        } else {
            try {
                this.put(qualifier, key, new String(Base64.encodeBase64((byte[])value), UTF_8), this.context, encrypt);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Gyrex requires a platform which supports UTF-8.", e);
            }
        }
    }

    @Override
    public void putDouble(String qualifier, String key, double value, boolean encrypt) throws SecurityException {
        this.put(qualifier, key, Double.toString(value), this.context, encrypt);
    }

    @Override
    public void putFloat(String qualifier, String key, float value, boolean encrypt) throws SecurityException {
        this.put(qualifier, key, Float.toString(value), this.context, encrypt);
    }

    @Override
    public void putInt(String qualifier, String key, int value, boolean encrypt) throws SecurityException {
        this.put(qualifier, key, Integer.toString(value), this.context, encrypt);
    }

    @Override
    public void putLong(String qualifier, String key, long value, boolean encrypt) throws SecurityException {
        this.put(qualifier, key, Long.toString(value), this.context, encrypt);
    }

    @Override
    public void remove(String qualifier, String key) throws SecurityException {
        GyrexContextPreferencesImpl.getNode(qualifier, key, this.context).remove(EclipsePreferencesUtil.decodePath((String)key)[1]);
    }

    @Override
    public void sync(String qualifier) throws BackingStoreException, SecurityException {
        if (ContextDebug.preferencesModify) {
            LOG.debug("Synchronizing preferences of context \"{}\" for qualifier \"{}\"", (Object)this.context, (Object)qualifier);
        }
        GyrexContextPreferencesImpl.getNode(qualifier, EMPTY, this.context).sync();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GyrexContextPreferencesImpl [context=").append(this.context).append("]");
        return builder.toString();
    }
}

