/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.provider;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.eclipse.gyrex.context.internal.provider.TypeRegistration;
import org.eclipse.gyrex.context.provider.RuntimeContextObjectProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ObjectProviderRegistry
implements IShutdownParticipant {
    private final ConcurrentMap<String, TypeRegistration> registrations = new ConcurrentHashMap<String, TypeRegistration>();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    private ServiceTracker objectProviderTracker;

    void flushProperties(RuntimeContextObjectProvider provider, ServiceReference reference) {
        Class<?>[] classArray = provider.getObjectTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            TypeRegistration registration = (TypeRegistration)this.registrations.get(type.getName());
            if (registration != null) {
                registration.update(type, provider, reference);
            }
            ++n2;
        }
    }

    public TypeRegistration getType(String objectTypeName) {
        return (TypeRegistration)this.registrations.get(objectTypeName);
    }

    void registerProvider(RuntimeContextObjectProvider provider, ServiceReference reference) {
        if (reference == null) {
            return;
        }
        Class<?>[] classArray = provider.getObjectTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            TypeRegistration registration = this.registrations.putIfAbsent(type.getName(), new TypeRegistration(type.getName()));
            if (registration == null) {
                registration = (TypeRegistration)this.registrations.get(type.getName());
            }
            registration.add(type, provider, reference);
            ++n2;
        }
    }

    public void shutdown() throws Exception {
        BundleContext context = this.contextRef.getAndSet(null);
        if (context == null) {
            return;
        }
        this.objectProviderTracker.close();
        this.objectProviderTracker = null;
    }

    public void start(BundleContext context) throws IllegalStateException {
        if (!this.contextRef.compareAndSet(null, context)) {
            throw new IllegalStateException("already (still?) active");
        }
        this.objectProviderTracker = new RuntimeContextObjectProviderTracker(context);
        this.objectProviderTracker.open();
    }

    void unregisterProvider(RuntimeContextObjectProvider provider, ServiceReference reference) {
        Class<?>[] classArray = provider.getObjectTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            TypeRegistration registration = (TypeRegistration)this.registrations.get(type.getName());
            if (registration != null) {
                registration.remove(type, provider, reference);
            }
            ++n2;
        }
    }

    private final class RuntimeContextObjectProviderTracker
    extends ServiceTracker<RuntimeContextObjectProvider, RuntimeContextObjectProvider> {
        private RuntimeContextObjectProviderTracker(BundleContext context) {
            super(context, RuntimeContextObjectProvider.class, null);
        }

        public RuntimeContextObjectProvider addingService(ServiceReference<RuntimeContextObjectProvider> reference) {
            RuntimeContextObjectProvider provider = (RuntimeContextObjectProvider)super.addingService(reference);
            if (provider != null) {
                ObjectProviderRegistry.this.registerProvider(provider, reference);
            }
            return provider;
        }

        public void modifiedService(ServiceReference<RuntimeContextObjectProvider> reference, RuntimeContextObjectProvider service) {
            RuntimeContextObjectProvider provider = service;
            if (provider != null) {
                ObjectProviderRegistry.this.flushProperties(provider, reference);
            }
        }

        public void removedService(ServiceReference<RuntimeContextObjectProvider> reference, RuntimeContextObjectProvider service) {
            RuntimeContextObjectProvider provider = service;
            if (provider != null) {
                ObjectProviderRegistry.this.unregisterProvider(provider, reference);
            }
            super.removedService(reference, (Object)service);
        }
    }
}

