/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.frameworklogadapter.internal;

import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

public class GyrexSlf4jForwarder
implements SynchronousLogListener,
LogFilter {
    private static final int DEFAULT_CAPACITY = 150;
    static final String EQUINOX_LOGGER_NAME = "org.eclipse.equinox.logger";
    static final String NEWLINE = System.getProperty("line.separator");
    final AtomicBoolean closed = new AtomicBoolean(false);
    final BlockingQueue<LogEntry> logBuffer;
    final AtomicReference<SLF4JLogger> activeLogger = new AtomicReference();
    ExecutorService logDispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Gyrex FrameworkLog Dispatcher");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final AtomicBoolean warningPrinted = new AtomicBoolean(false);

    public GyrexSlf4jForwarder(int bufferSize) {
        this.logBuffer = new LinkedBlockingQueue<LogEntry>(bufferSize > 0 ? bufferSize : 150);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.shutdown();
        }
    }

    public boolean isLoggable(Bundle bundle, String loggerName, int logLevel) {
        if (loggerName != null && !EQUINOX_LOGGER_NAME.equals(loggerName)) {
            return false;
        }
        switch (logLevel) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return EclipseStarter.debug;
    }

    public void logged(LogEntry entry) {
        if (entry != null && !this.closed.get() && !this.logBuffer.offer(entry) && EclipseStarter.debug && !this.warningPrinted.get() && this.warningPrinted.compareAndSet(false, true)) {
            System.err.println("[Eclipse Gyrex] Log buffer capacity limit reached. Some framework log messages will be discarded. Try lowering the log level or increasing the buffer size (system property 'gyrex.log.forwarder.buffer.size').");
        }
    }

    public void setSLF4JLogger(Object logger) {
        this.activeLogger.set(logger != null ? new SLF4JLogger(logger) : null);
        if (logger != null) {
            this.startDispatcher();
        }
    }

    private void shutdown() {
        this.logDispatcher.shutdownNow();
        this.logBuffer.clear();
    }

    private void startDispatcher() {
        if (!this.closed.get()) {
            try {
                this.logDispatcher.execute(new Dispatcher());
            }
            catch (RejectedExecutionException e) {
                throw new IllegalStateException("inactive", e);
            }
        }
    }

    final class Dispatcher
    implements Runnable {
        Dispatcher() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                SLF4JLogger logger;
                LogEntry entry = null;
                while (entry == null && !GyrexSlf4jForwarder.this.closed.get()) {
                    try {
                        entry = GyrexSlf4jForwarder.this.logBuffer.take();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (entry == null || GyrexSlf4jForwarder.this.closed.get() || (logger = GyrexSlf4jForwarder.this.activeLogger.get()) == null) continue;
                logger.log(entry);
            }
        }
    }

    static final class SLF4JLogger {
        static final int TRACE_INT = 0;
        static final int DEBUG_INT = 10;
        static final int INFO_INT = 20;
        static final int WARN_INT = 30;
        static final int ERROR_INT = 40;
        private final Object logger;
        private final Method logMethod;

        private static Method findLogMethod(Object logger) {
            Method[] methods;
            Method[] methodArray = methods = logger.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Class<?>[] parameterTypes = method.getParameterTypes();
                if ("log".equals(method.getName()) && parameterTypes.length == 6 && parameterTypes[1].equals(String.class) && parameterTypes[2].equals(Integer.TYPE) && parameterTypes[3].equals(String.class) && parameterTypes[5].equals(Throwable.class)) {
                    return method;
                }
                ++n2;
            }
            return null;
        }

        public SLF4JLogger(Object logger) {
            this.logger = logger;
            this.logMethod = SLF4JLogger.findLogMethod(logger);
        }

        private void addServiceProperty(ServiceReference sr, String key, StringBuilder serviceInfo) {
            Object value = sr.getProperty(key);
            if (value != null) {
                if (serviceInfo.length() > 0) {
                    serviceInfo.append(", ");
                }
                serviceInfo.append(key).append(": ");
                if (value.getClass().isArray()) {
                    Object[] values = (Object[])value;
                    String separator = "";
                    Object[] objectArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object val = objectArray[n2];
                        serviceInfo.append(separator).append(val);
                        separator = ",";
                        ++n2;
                    }
                } else {
                    serviceInfo.append(value);
                }
            }
        }

        private Object getLevel(LogEntry entry) {
            switch (entry.getLevel()) {
                case 1: {
                    return 40;
                }
                case 2: {
                    return 30;
                }
                case 3: {
                    return 20;
                }
            }
            return 10;
        }

        private String getMessage(LogEntry entry) {
            ServiceReference sr = entry.getServiceReference();
            if (sr != null) {
                StringBuilder serviceInfo = new StringBuilder(400);
                this.addServiceProperty(sr, "service.pid", serviceInfo);
                this.addServiceProperty(sr, "service.id", serviceInfo);
                this.addServiceProperty(sr, "service.vendor", serviceInfo);
                this.addServiceProperty(sr, "objectClass", serviceInfo);
                return String.format("%s - %s", entry.getMessage(), serviceInfo.toString());
            }
            Bundle bundle = entry.getBundle();
            if (bundle != null && bundle.getBundleId() != 0L) {
                return String.format("%s - %s, id: %d", entry.getMessage(), bundle.getSymbolicName(), bundle.getBundleId());
            }
            return entry.getMessage();
        }

        public void log(LogEntry entry) {
            if (this.logMethod == null) {
                return;
            }
            try {
                this.logMethod.invoke(this.logger, null, "org.eclipse.osgi.framework.log.FrameworkLogEntry", this.getLevel(entry), this.getMessage(entry), null, entry.getException());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

