/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class StatusMonitor
extends ServiceTracker<IStatus, IStatus> {
    private final CopyOnWriteArrayList<IStatus> statusList = new CopyOnWriteArrayList();
    private volatile IStatus overallStatus = Status.OK_STATUS;

    public StatusMonitor(BundleContext context) {
        super(context, IStatus.class, null);
    }

    public IStatus addingService(ServiceReference<IStatus> reference) {
        IStatus status = (IStatus)super.addingService(reference);
        if (status != null) {
            this.statusList.add(status);
            this.updateStatus();
        }
        return status;
    }

    public IStatus getOverallStatus() {
        IStatus status = this.overallStatus;
        if (status == null) {
            return Status.OK_STATUS;
        }
        return status;
    }

    public void modifiedService(ServiceReference<IStatus> reference, IStatus service) {
        this.updateStatus();
    }

    public void removedService(ServiceReference<IStatus> reference, IStatus service) {
        this.statusList.remove(service);
        this.updateStatus();
        super.removedService(reference, (Object)service);
    }

    void updateStatus() {
        IStatus[] states = this.statusList.toArray(new IStatus[0]);
        if (states.length == 0) {
            this.overallStatus = Status.OK_STATUS;
            return;
        }
        this.overallStatus = new MultiStatus("org.eclipse.gyrex.http.jetty", 0, states, null, null);
    }
}

