/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.admin.CertificateDefinition;
import org.eclipse.gyrex.monitoring.diagnostics.IStatusConstants;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyManagerImpl
implements IJettyManager {
    private static final String PREF_NODE_CHANNELS = "channels";
    private static final String PREF_NODE_CERTIFICATES = "certs";
    private static final String PREF_KEY_CERTIFICATE_ID = "certificateId";
    private static final String PREF_KEY_NODE_FILTER = "nodeFilter";
    private static final String PREF_KEY_SECURE_CHANNEL_ID = "secureChannelId";
    private static final String PREF_KEY_SECURE = "secure";
    private static final String PREF_KEY_PORT = "port";
    private static final String PREF_KEY_KEY_PASSWORD = "keyPassword";
    private static final String PREF_KEY_KEYSTORE_PASSWORD = "keystorePassword";
    private static final String PREF_KEY_KEYSTORE_BYTES = "keystoreBytes";
    private static final Logger LOG = LoggerFactory.getLogger(JettyManagerImpl.class);
    private Status restartStatus;

    @Override
    public void addCertificate(String certificateId, byte[] keystoreBytes, char[] keystorePassword, char[] keyPassword) {
        if (!IdHelper.isValidId((String)certificateId)) {
            throw new IllegalArgumentException("invalid id");
        }
        try {
            Preferences node = this.getCertificateNode(certificateId);
            node.putByteArray(PREF_KEY_KEYSTORE_BYTES, keystoreBytes);
            if (keystorePassword != null) {
                node.put(PREF_KEY_KEYSTORE_PASSWORD, new String(keystorePassword));
            } else {
                node.remove(PREF_KEY_KEYSTORE_PASSWORD);
            }
            if (keyPassword != null) {
                node.put(PREF_KEY_KEY_PASSWORD, new String(keyPassword));
            } else {
                node.remove(PREF_KEY_KEY_PASSWORD);
            }
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error saving certificate to backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public ICertificate getCertificate(String certificateId) {
        block6: {
            IEclipsePreferences rootNode;
            block5: {
                try {
                    if (!IdHelper.isValidId((String)certificateId)) {
                        throw new IllegalArgumentException("invalid id");
                    }
                    rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
                    if (rootNode.nodeExists(PREF_NODE_CERTIFICATES)) break block5;
                    return null;
                }
                catch (BackingStoreException e) {
                    throw new IllegalStateException("Error reading certificate from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
                }
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_CERTIFICATES);
            if (channelsNode.nodeExists(certificateId)) break block6;
            return null;
        }
        return this.readCertificate(certificateId);
    }

    private Preferences getCertificateNode(String certificateId) {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty").node(PREF_NODE_CERTIFICATES).node(certificateId);
    }

    @Override
    public Collection<ICertificate> getCertificates() {
        try {
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
            if (!rootNode.nodeExists(PREF_NODE_CERTIFICATES)) {
                return Collections.emptyList();
            }
            Preferences certificatesNode = rootNode.node(PREF_NODE_CERTIFICATES);
            String[] childrenNames = certificatesNode.childrenNames();
            ArrayList<ICertificate> certs = new ArrayList<ICertificate>();
            String[] stringArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String certId = stringArray[n2];
                ICertificate cert = this.readCertificate(certId);
                if (cert != null) {
                    certs.add(cert);
                }
                ++n2;
            }
            return certs;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading certificates from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public ChannelDescriptor getChannel(String channelId) {
        block6: {
            IEclipsePreferences rootNode;
            block5: {
                try {
                    if (!IdHelper.isValidId((String)channelId)) {
                        throw new IllegalArgumentException("invalid id");
                    }
                    rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
                    if (rootNode.nodeExists(PREF_NODE_CHANNELS)) break block5;
                    return null;
                }
                catch (BackingStoreException e) {
                    throw new IllegalStateException("Error reading channel from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
                }
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_CHANNELS);
            if (channelsNode.nodeExists(channelId)) break block6;
            return null;
        }
        return this.readChannel(channelId);
    }

    private Preferences getChannelNode(String channelId) {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty").node(PREF_NODE_CHANNELS).node(channelId);
    }

    @Override
    public Collection<ChannelDescriptor> getChannels() {
        try {
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
            if (!rootNode.nodeExists(PREF_NODE_CHANNELS)) {
                return Collections.emptyList();
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_CHANNELS);
            String[] childrenNames = channelsNode.childrenNames();
            ArrayList<ChannelDescriptor> channels = new ArrayList<ChannelDescriptor>();
            String[] stringArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String channelId = stringArray[n2];
                ChannelDescriptor descriptor = this.readChannel(channelId);
                if (descriptor != null) {
                    channels.add(descriptor);
                }
                ++n2;
            }
            return channels;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading channels from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public Collection<ChannelDescriptor> getChannelsUsingCertificate(String certificateId) {
        Collection<ChannelDescriptor> channels = this.getChannels();
        ArrayList<ChannelDescriptor> certificateChannels = new ArrayList<ChannelDescriptor>();
        for (ChannelDescriptor channelDescriptor : channels) {
            if (!StringUtils.equals((String)certificateId, (String)channelDescriptor.getCertificateId())) continue;
            certificateChannels.add(channelDescriptor);
        }
        return Collections.unmodifiableCollection(certificateChannels);
    }

    private ICertificate readCertificate(String certificateId) {
        try {
            String keyPassword;
            CertificateDefinition definition = new CertificateDefinition();
            definition.setId(certificateId);
            Preferences node = this.getCertificateNode(certificateId);
            definition.setKeystoreBytes(node.getByteArray(PREF_KEY_KEYSTORE_BYTES, null));
            String keystorePassword = node.get(PREF_KEY_KEYSTORE_PASSWORD, null);
            if (keystorePassword != null) {
                definition.setKeystorePassword(keystorePassword.toCharArray());
            }
            if ((keyPassword = node.get(PREF_KEY_KEY_PASSWORD, null)) != null) {
                definition.setKeyPassword(keyPassword.toCharArray());
            }
            return definition;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to read Jetty certificate {}. {}", (Object)certificateId, (Object)e.getMessage());
            return null;
        }
    }

    private ChannelDescriptor readChannel(String channelId) {
        try {
            ChannelDescriptor descriptor = new ChannelDescriptor();
            descriptor.setId(channelId);
            Preferences node = this.getChannelNode(channelId);
            descriptor.setPort(node.getInt(PREF_KEY_PORT, 0));
            descriptor.setSecure(node.getBoolean(PREF_KEY_SECURE, false));
            descriptor.setSecureChannelId(node.get(PREF_KEY_SECURE_CHANNEL_ID, null));
            descriptor.setCertificateId(node.get(PREF_KEY_CERTIFICATE_ID, null));
            descriptor.setNodeFilter(node.get(PREF_KEY_NODE_FILTER, null));
            return descriptor;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to read Jetty channel {}. {}", (Object)channelId, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public void removeCertificate(String certificateId) {
        try {
            if (!IdHelper.isValidId((String)certificateId)) {
                throw new IllegalArgumentException("invalid id");
            }
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
            if (!rootNode.nodeExists(PREF_NODE_CERTIFICATES)) {
                return;
            }
            Preferences certificatesNode = rootNode.node(PREF_NODE_CERTIFICATES);
            if (!certificatesNode.nodeExists(certificateId)) {
                return;
            }
            certificatesNode.node(certificateId).removeNode();
            certificatesNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error removing certificate from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void removeChannel(String channelId) {
        try {
            if (!IdHelper.isValidId((String)channelId)) {
                throw new IllegalArgumentException("invalid id");
            }
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
            if (!rootNode.nodeExists(PREF_NODE_CHANNELS)) {
                return;
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_CHANNELS);
            if (!channelsNode.nodeExists(channelId)) {
                return;
            }
            channelsNode.node(channelId).removeNode();
            channelsNode.flush();
            this.restartMayBeNeeded();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error removing channel from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private void restartMayBeNeeded() {
        if (this.restartStatus != null) {
            return;
        }
        this.restartStatus = new Status(1, "org.eclipse.gyrex.http.jetty", "The Jetty configuration has been modified. A restart may be neccessary in order to activate the changes.");
        HttpJettyActivator.getInstance().getServiceHelper().registerService(IStatusConstants.SERVICE_NAME, (Object)this.restartStatus, "Eclipse Gyrex", "Jetty Restart Info", "org.eclipse.gyrex.http.jetty".concat(".restart.necessary"), null);
    }

    @Override
    public void saveChannel(ChannelDescriptor channel) {
        try {
            Preferences node = this.getChannelNode(channel.getId());
            node.putInt(PREF_KEY_PORT, channel.getPort());
            node.putBoolean(PREF_KEY_SECURE, channel.isSecure());
            String secureChannelId = channel.getSecureChannelId();
            if (StringUtils.isNotBlank((String)secureChannelId)) {
                node.put(PREF_KEY_SECURE_CHANNEL_ID, secureChannelId);
            } else {
                node.remove(PREF_KEY_SECURE_CHANNEL_ID);
            }
            String certificateId = channel.getCertificateId();
            if (StringUtils.isNotBlank((String)certificateId)) {
                node.put(PREF_KEY_CERTIFICATE_ID, certificateId);
            } else {
                node.remove(PREF_KEY_CERTIFICATE_ID);
            }
            String nodeFilter = channel.getNodeFilter();
            if (StringUtils.isNotBlank((String)nodeFilter)) {
                node.put(PREF_KEY_NODE_FILTER, nodeFilter);
            } else {
                node.remove(PREF_KEY_NODE_FILTER);
            }
            node.flush();
            this.restartMayBeNeeded();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error saving channel to backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }
}

