/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import javax.servlet.Servlet;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationServletHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServletHandler
extends ServletHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationServletHandler.class);
    private final ApplicationHandler applicationHandler;

    public ApplicationServletHandler(ApplicationHandler applicationHandler) {
        this.applicationHandler = applicationHandler;
    }

    public ApplicationHandler getApplicationHandler() {
        return this.applicationHandler;
    }

    public ServletHolder newServletHolder() {
        return new ApplicationServletHolder();
    }

    public ServletHolder newServletHolder(Class<? extends Servlet> servlet) {
        return new ApplicationServletHolder(servlet);
    }

    public void removeServlet(ServletHolder holder) {
        this.setServlets((ServletHolder[])LazyList.removeFromArray((Object[])this.getServlets(), (Object)holder));
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        super.setServletMappings(servletMappings);
        if (JettyDebug.handlers) {
            LOG.debug("Updated servlet mappings {}", (Object)this.dump());
        }
    }
}

