/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.connectors;

import java.io.InputStream;
import java.security.KeyStore;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.jetty.http.ssl.SslContextFactory;

public class CertificateSslContextFactory
extends SslContextFactory {
    private final ICertificate certificate;

    public CertificateSslContextFactory(ICertificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate must not be null");
        }
        this.certificate = certificate;
        this.setKeyStore("certificate:key:" + certificate.getId());
        this.setTrustStore("certificate:trust:" + certificate.getId());
        this.setKeyManagerPassword(new String(certificate.getKeyPassword()));
    }

    protected KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        return this.certificate.getKeyStore();
    }
}

