/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.registry.internal.ApplicationRegistryManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class ApplicationManagerServiceTracker
extends ServiceTracker {
    private final ConcurrentMap<ServiceReference, ApplicationRegistryManager> applicationRegistryManagers = new ConcurrentHashMap<ServiceReference, ApplicationRegistryManager>(2);
    private final PackageAdmin packageAdmin;
    private final IExtensionRegistry extensionRegistry;
    private final IRuntimeContextRegistry contextRegistry;

    public ApplicationManagerServiceTracker(BundleContext context, PackageAdmin packageAdmin, IExtensionRegistry extensionRegistry, IRuntimeContextRegistry contextRegistry) {
        super(context, IApplicationManager.class.getName(), null);
        this.packageAdmin = packageAdmin;
        this.extensionRegistry = extensionRegistry;
        this.contextRegistry = contextRegistry;
    }

    public Object addingService(ServiceReference reference) {
        IApplicationManager applicationManager = (IApplicationManager)super.addingService(reference);
        if (applicationManager == null) {
            return null;
        }
        ApplicationRegistryManager applicationRegistryManager = new ApplicationRegistryManager(reference, applicationManager, this.packageAdmin, this.extensionRegistry, this.contextRegistry);
        if (this.applicationRegistryManagers.putIfAbsent(reference, applicationRegistryManager) == null) {
            applicationRegistryManager.start();
        }
        return applicationManager;
    }

    public void removedService(ServiceReference reference, Object service) {
        ApplicationRegistryManager applicationManager = (ApplicationRegistryManager)this.applicationRegistryManagers.remove(reference);
        if (applicationManager != null) {
            applicationManager.stop();
        }
        super.removedService(reference, service);
    }
}

