/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleFinder
implements PrivilegedAction<List<Bundle>> {
    static final Finder contextFinder = AccessController.doPrivileged(new PrivilegedAction<Finder>(){

        @Override
        public Finder run() {
            return new Finder();
        }
    });
    private final Bundle host;
    private final Bundle bundleFinderHost;

    public BundleFinder(Bundle host) {
        this.host = host;
        this.bundleFinderHost = FrameworkUtil.getBundle(this.getClass());
    }

    private List<Bundle> findBundles() {
        if (System.getSecurityManager() == null) {
            return this.internalFindBundles();
        }
        return AccessController.doPrivileged(this);
    }

    public Bundle getCallingBundle() {
        List<Bundle> bundles = this.findBundles();
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles.iterator().next();
    }

    private List<Bundle> internalFindBundles() {
        Class[] stack = contextFinder.getClassContext();
        ArrayList<Bundle> result = new ArrayList<Bundle>(1);
        Class[] classArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            Bundle bundle = FrameworkUtil.getBundle((Class)clazz);
            if (bundle != null && !bundle.equals(this.host) && !bundle.equals(this.bundleFinderHost)) {
                result.add(bundle);
                return result;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<Bundle> run() {
        return this.internalFindBundles();
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

