/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.jobs.internal.commands.BaseScheduleStoreCmd;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.kohsuke.args4j.Argument;

public class UpdateEntryToScheduleCmd
extends BaseScheduleStoreCmd {
    @Argument(index=1, usage="the entry id", required=true, metaVar="ID")
    String entryId;
    @Argument(index=2, usage="parameter key", required=true, metaVar="STRING")
    String jobParamKey;
    @Argument(index=3, usage="parameter value", required=false, metaVar="STRING")
    String jobParamValue;

    public UpdateEntryToScheduleCmd() {
        super("<entryId> <jobParamKey> [<jobParamValue>] - Sets (or removes) an entry job paramater");
    }

    @Override
    protected void doExecute(String storageId, String scheduleId) throws Exception {
        ScheduleImpl schedule = ScheduleStore.load(storageId, scheduleId, true);
        if (schedule.isEnabled()) {
            this.printf("Schedule %s is enabled, please disable first!", new Object[]{scheduleId});
            return;
        }
        ScheduleEntryImpl entry = schedule.getEntry(this.entryId);
        HashMap<String, String> parameter = new HashMap<String, String>(entry.getJobParameter());
        if (StringUtils.isBlank((String)this.jobParamValue)) {
            parameter.remove(this.jobParamKey);
        } else {
            parameter.put(this.jobParamKey, this.jobParamValue);
        }
        entry.setJobParameter(parameter);
        ScheduleStore.flush(storageId, schedule);
        this.printf("Updated schedule %s entry %s!", new Object[]{scheduleId, this.entryId});
    }
}

