/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.CleanupJob;
import org.eclipse.gyrex.jobs.internal.manager.IJobStateWatch;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryStore;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerImpl
implements IJobManager {
    private static final String NODE_PARAMETER = "parameter";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_STATUS = "status";
    private static final String PROPERTY_LAST_START = "lastStart";
    private static final String PROPERTY_LAST_SUCCESSFUL_FINISH = "lastSuccessfulFinish";
    private static final String PROPERTY_LAST_RESULT_MESSAGE = "lastResultMessage";
    private static final String PROPERTY_LAST_RESULT_SEVERITY = "lastResultSeverity";
    private static final String PROPERTY_LAST_RESULT = "lastResultTimestamp";
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerImpl.class);
    private static AtomicLong lastCleanup = new AtomicLong();
    static final String SEPARATOR = "_";
    private final IRuntimeContext context;
    private final String internalIdPrefix;
    static final String NODE_STATES = "status";

    static String getExternalId(String internalId) {
        int i = internalId.indexOf(SEPARATOR);
        if (i < 0) {
            return internalId;
        }
        return internalId.substring(i + 1);
    }

    static IEclipsePreferences getStatesNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node("status");
    }

    static JobImpl readJob(String jobId, Preferences node) throws BackingStoreException {
        JobImpl job = new JobImpl();
        job.setId(jobId);
        job.setTypeId(node.get(PROPERTY_TYPE, null));
        job.setStatus(JobManagerImpl.toState(node.get("status", null)));
        job.setLastStart(node.getLong(PROPERTY_LAST_START, -1L));
        job.setLastSuccessfulFinish(node.getLong(PROPERTY_LAST_SUCCESSFUL_FINISH, -1L));
        long lastResultTimestamp = node.getLong(PROPERTY_LAST_RESULT, -1L);
        if (lastResultTimestamp > -1L) {
            job.setLastResult(lastResultTimestamp, node.getInt(PROPERTY_LAST_RESULT_SEVERITY, 8), node.get(PROPERTY_LAST_RESULT_MESSAGE, ""));
        }
        if (node.nodeExists(NODE_PARAMETER)) {
            Preferences paramNode = node.node(NODE_PARAMETER);
            String[] keys = paramNode.keys();
            HashMap<String, String> jobParamater = new HashMap<String, String>(keys.length);
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                jobParamater.put(key, paramNode.get(key, null));
                ++n2;
            }
            job.setParameter(jobParamater);
        }
        return job;
    }

    static JobState toState(Object value) {
        if (value instanceof String) {
            try {
                return Enum.valueOf(JobState.class, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return JobState.NONE;
            }
        }
        return JobState.NONE;
    }

    @Inject
    public JobManagerImpl(IRuntimeContext context) {
        this.context = context;
        try {
            this.internalIdPrefix = String.valueOf(DigestUtils.shaHex((byte[])context.getContextPath().toString().getBytes("UTF-8"))) + SEPARATOR;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Please use a JVM that supports UTF-8.");
        }
    }

    @Override
    public void cancelJob(String jobId) throws IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.WAITING && job.getState() != JobState.RUNNING) {
            return;
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = this.getLock(job);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (job.getState() != JobState.WAITING && job.getState() != JobState.RUNNING) {
                return;
            }
            try {
                this.setJobState(job, JobState.ABORTING, jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error canceling job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            this.releaseLock(jobLock, jobId);
        }
    }

    @Override
    public IJob createJob(String jobTypeId, String jobId, Map<String, String> parameter) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            String internalId = this.toInternalId(jobId);
            if (JobHistoryStore.getJobsNode().nodeExists(internalId)) {
                throw new IllegalStateException(String.format("Job '%s' is already stored", jobId));
            }
            Preferences node = JobHistoryStore.getJobsNode().node(internalId);
            node.put(PROPERTY_TYPE, jobTypeId);
            node.flush();
            JobImpl job = JobManagerImpl.readJob(jobId, node);
            jobLock = this.getLock(job);
            this.setJobParameter(job, parameter, jobLock);
            this.setJobState(job, JobState.NONE, jobLock);
            JobImpl jobImpl = JobManagerImpl.readJob(jobId, node);
            this.releaseLock(jobLock, jobId);
            return jobImpl;
        }
        catch (BackingStoreException e) {
            try {
                throw new IllegalStateException(String.format("Error creating job data. %s", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                this.releaseLock(jobLock, jobId);
                throw throwable;
            }
        }
    }

    @Override
    public JobHistoryImpl getHistory(String jobId) throws IllegalStateException {
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job '%s' does not exist.", jobId));
        }
        try {
            return JobHistoryStore.create(this.toInternalId(jobId), jobId, this.context);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading history", e);
        }
    }

    @Override
    public JobImpl getJob(String jobId) {
        String internalId;
        block4: {
            if (!IdHelper.isValidId((String)jobId)) {
                throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
            }
            try {
                internalId = this.toInternalId(jobId);
                if (JobHistoryStore.getJobsNode().nodeExists(internalId)) break block4;
                return null;
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
            }
        }
        return JobManagerImpl.readJob(jobId, JobHistoryStore.getJobsNode().node(internalId));
    }

    @Override
    public Collection<String> getJobs() {
        try {
            String[] storageIds = JobHistoryStore.getJobsNode().childrenNames();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (internalId.startsWith(this.internalIdPrefix)) {
                    jobIds.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    @Override
    public Collection<String> getJobsByState(JobState state) {
        if (state == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        try {
            IEclipsePreferences statesNode = JobManagerImpl.getStatesNode();
            if (!statesNode.nodeExists(state.name())) {
                return Collections.emptyList();
            }
            String[] storageIds = statesNode.node(state.name()).keys();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (internalId.startsWith(this.internalIdPrefix)) {
                    jobIds.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    private IExclusiveLock getLock(IJob job) {
        String lockId = "gyrex.jobs.".concat(this.toInternalId(job.getId()));
        if (JobsDebug.jobLocks) {
            LOG.debug("Requesting lock {} for job {}", new Object[]{lockId, job.getId(), new Exception("Call Stack")});
        }
        try {
            return ((ILockService)JobsActivator.getInstance().getService(ILockService.class)).acquireExclusiveLock(lockId, null, 2000L);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to get job lock. %s", e.getMessage()), e);
        }
    }

    @Override
    public void queueJob(String jobId, String queueId) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.NONE) {
            throw new IllegalStateException(String.format("Job %s cannot be queued because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IQueue queue = JobsActivator.getInstance().getQueueService().getQueue(queueId != null ? queueId : "gyrex.jobs.queue.default", null);
        if (queue == null) {
            throw new IllegalStateException(String.format("Queue %s does not exist!", queueId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = this.getLock(job);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (job.getState() != JobState.NONE) {
                throw new IllegalStateException(String.format("Job %s cannot be queued because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
            }
            try {
                this.setJobState(job, JobState.WAITING, jobLock);
                queue.sendMessage(JobInfo.asMessage(new JobInfo(job.getTypeId(), jobId, this.context.getContextPath(), job.getParameter())));
            }
            catch (Exception e) {
                try {
                    this.setJobState(job, JobState.NONE, jobLock);
                }
                catch (Exception exception) {
                    LOG.warn("Unable to reset job state for job {}: {}", (Object)jobId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                throw new IllegalStateException(String.format("Error queuing job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            this.releaseLock(jobLock, jobId);
        }
        this.triggerCleanUp();
    }

    private void releaseLock(IExclusiveLock jobLock, String jobId) {
        if (jobLock != null) {
            if (JobsDebug.jobLocks) {
                LOG.debug("Releasing lock {} for job {}", new Object[]{jobLock.getId(), jobId});
            }
            try {
                jobLock.release();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void removeJob(String jobId) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job.getState() != JobState.NONE) {
            throw new IllegalStateException(String.format("Job %s cannot be removed because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IExclusiveLock jobLock = null;
        try {
            try {
                jobLock = this.getLock(job);
                String internalId = this.toInternalId(jobId);
                IEclipsePreferences jobsNode = JobHistoryStore.getJobsNode();
                if (jobsNode.nodeExists(internalId)) {
                    jobsNode.node(internalId).removeNode();
                    jobsNode.flush();
                }
                IEclipsePreferences statesNode = JobManagerImpl.getStatesNode();
                JobState[] jobStateArray = JobState.values();
                int n = jobStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JobState state = jobStateArray[n2];
                    Preferences node = statesNode.node(state.name());
                    if (node.get(internalId, null) != null) {
                        node.remove(internalId);
                        node.flush();
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error removing job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            this.releaseLock(jobLock, jobId);
        }
    }

    private void setJobParameter(IJob job, Map<String, String> parameter, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update parameter of job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        if (parameter != null && !parameter.isEmpty()) {
            Preferences paramNode = jobNode.node(NODE_PARAMETER);
            String[] stringArray = paramNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (StringUtils.isBlank((String)parameter.get(key))) {
                    paramNode.remove(key);
                }
                ++n2;
            }
            for (String key : parameter.keySet()) {
                String value = parameter.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                paramNode.put(key, value);
            }
        } else if (jobNode.nodeExists(NODE_PARAMETER)) {
            jobNode.node(NODE_PARAMETER).removeNode();
        }
        jobNode.flush();
    }

    private void setJobResult(IJob job, IStatus result, long resultTimestamp, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job result of job %s due to missing or lost job lock!", job.getId()));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Unable to update job result of job %s due to missing result!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        jobNode.putLong(PROPERTY_LAST_RESULT, resultTimestamp);
        jobNode.put(PROPERTY_LAST_RESULT_MESSAGE, result.getMessage());
        jobNode.putInt(PROPERTY_LAST_RESULT_SEVERITY, result.getSeverity());
        if (result.isOK()) {
            jobNode.putLong(PROPERTY_LAST_SUCCESSFUL_FINISH, resultTimestamp);
        }
        JobHistoryImpl history = JobHistoryStore.create(internalId, job.getId(), this.context);
        history.createEntry(resultTimestamp, result.getMessage(), result.getSeverity());
        JobHistoryStore.flush(internalId, history);
    }

    private void setJobStartTime(IJob job, long startTimestamp, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        jobNode.putLong(PROPERTY_LAST_START, startTimestamp);
        jobNode.flush();
    }

    private void setJobState(IJob job, JobState state, IExclusiveLock lock) throws BackingStoreException {
        if (state == null) {
            throw new IllegalArgumentException("job state must not be null");
        }
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job state of job %s to %s due to missing or lost job lock!", job.getId(), state.toString()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        if (StringUtils.equals((String)jobNode.get("status", null), (String)state.name())) {
            return;
        }
        jobNode.put("status", state.name());
        jobNode.flush();
        IEclipsePreferences statesNode = JobManagerImpl.getStatesNode();
        JobState[] jobStateArray = JobState.values();
        int n = jobStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            JobState currentState = jobStateArray[n2];
            if (!currentState.equals((Object)state)) {
                statesNode.node(currentState.name()).remove(internalId);
            } else {
                statesNode.node(currentState.name()).putBoolean(internalId, true);
            }
            statesNode.flush();
            ++n2;
        }
    }

    public void setJobState(String jobId, JobState expected, JobState state, IJobStateWatch stateWatch) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (state == null) {
            throw new IllegalArgumentException("Job state must not be null");
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = this.getLock(job);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (expected != null && job.getState() != expected) {
                return;
            }
            try {
                this.setJobState(job, state, jobLock);
                if (state == JobState.RUNNING) {
                    this.setJobStartTime(job, System.currentTimeMillis(), jobLock);
                }
                if (stateWatch != null) {
                    ((IEclipsePreferences)JobHistoryStore.getJobsNode().node(this.toInternalId(jobId))).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new StateWatchListener(jobId, state, stateWatch));
                }
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error updating state of job %s to %s. %s", jobId, state.name(), e.getMessage()), e);
            }
        }
        finally {
            this.releaseLock(jobLock, jobId);
        }
    }

    public void setResult(String jobId, IStatus result, long resultTimestamp) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = this.getLock(job);
            try {
                this.setJobState(job, JobState.NONE, jobLock);
                this.setJobResult(job, result, resultTimestamp, jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error setting result of job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            this.releaseLock(jobLock, jobId);
        }
    }

    private String toExternalId(String internalId) {
        return StringUtils.removeStart((String)internalId, (String)this.internalIdPrefix);
    }

    private String toInternalId(String id) {
        return this.internalIdPrefix.concat(id);
    }

    private void triggerCleanUp() {
        long last = lastCleanup.get();
        if (System.currentTimeMillis() - last > TimeUnit.HOURS.toMillis(3L) && lastCleanup.compareAndSet(last, System.currentTimeMillis())) {
            new CleanupJob().schedule();
        }
    }

    private static class StateWatchListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final String jobId;
        private final JobState state;
        private final IJobStateWatch stateWatch;

        public StateWatchListener(String jobId, JobState state, IJobStateWatch stateWatch) {
            this.jobId = jobId;
            this.state = state;
            this.stateWatch = stateWatch;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"status".equals(event.getKey())) {
                return;
            }
            JobState newState = JobManagerImpl.toState(event.getNewValue());
            if (newState != this.state) {
                try {
                    this.stateWatch.jobStateChanged(this.jobId);
                }
                finally {
                    ((IEclipsePreferences)event.getNode()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                }
            }
        }
    }
}

