/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.monitoring;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.monitoring.IJobMonitor;
import org.osgi.framework.ServiceRegistration;

public class JobLogMonitor
extends ProgressMonitorWrapper
implements IJobMonitor {
    int totalWork;
    int worked;
    String currentTask;
    ServiceRegistration<IJobMonitor> serviceRegistration;
    final String jobId;

    public JobLogMonitor(IProgressMonitor monitor, String jobId) {
        super(monitor);
        this.jobId = jobId;
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        this.totalWork = totalWork;
        this.serviceRegistration = JobsActivator.getInstance().getServiceHelper().registerService(IJobMonitor.class, (Object)this, "Ageto Service GmbH", "Job monitor for " + this.jobId, null, Integer.valueOf(-1));
    }

    public void done() {
        super.done();
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @Override
    public String getCurrentTask() {
        return this.currentTask;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public int getTotalWork() {
        return this.totalWork;
    }

    @Override
    public int getWorked() {
        return this.worked;
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        this.currentTask = name;
    }

    public void worked(int work) {
        super.worked(work);
        this.worked = Math.min(this.totalWork, this.worked + work);
    }
}

