/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerApplication
implements IApplication {
    private static final Integer EXIT_ERROR = 1;
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerApplication.class);
    private static final AtomicReference<Scheduler> schedulerRef = new AtomicReference<Object>(null);
    private IApplicationContext runningContext;

    public Object start(IApplicationContext context) throws Exception {
        Scheduler scheduler;
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting scheduler engine application.");
        }
        if (!schedulerRef.compareAndSet(null, scheduler = new Scheduler())) {
            throw new IllegalStateException("Scheduler engine already running!");
        }
        try {
            scheduler.schedule();
            context.applicationRunning();
            this.runningContext = context;
            return IApplicationContext.EXIT_ASYNC_RESULT;
        }
        catch (Exception e) {
            LOG.error("Unable to start scheduler engine. Please check the log files.", (Throwable)e);
            return EXIT_ERROR;
        }
    }

    public void stop() {
        IApplicationContext context = this.runningContext;
        if (context == null) {
            throw new IllegalStateException("not started");
        }
        Scheduler scheduler = schedulerRef.getAndSet(null);
        if (scheduler == null) {
            return;
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Stopping scheduler engine application...");
        }
        if (!scheduler.cancel()) {
            try {
                LOG.info("Waiting for scheduler engine to shutdown...");
                scheduler.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting scheduler engine stopped.");
        }
        context.setResult((Object)EXIT_OK, (IApplication)this);
    }
}

