/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SchedulingJob
implements Job {
    static final String INTERNAL_PROP_PREFIX = "gyrex.job.";
    public static final String PROP_JOB_ID = "gyrex.job.id";
    public static final String PROP_JOB_TYPE_ID = "gyrex.job.type";
    public static final String PROP_JOB_CONTEXT_PATH = "gyrex.job.contextPath";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getMergedJobDataMap();
        String jobId = dataMap.getString(PROP_JOB_ID);
        String jobTypeId = dataMap.getString(PROP_JOB_TYPE_ID);
        String jobContextPath = dataMap.getString(PROP_JOB_CONTEXT_PATH);
        try {
            IQueueService queueService;
            IQueue queue;
            HashMap<String, String> parameter = new HashMap<String, String>();
            for (Object keyObj : dataMap.keySet()) {
                Object value;
                String key;
                if (!(keyObj instanceof String) || StringUtils.startsWith((String)(key = (String)keyObj), (String)INTERNAL_PROP_PREFIX) || !((value = dataMap.get((Object)key)) instanceof String)) continue;
                parameter.put(key, (String)value);
            }
            IRuntimeContext runtimeContext = ((IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)new Path(jobContextPath));
            if (runtimeContext == null) {
                throw new IllegalStateException(String.format("Context '%s' not found!", jobContextPath));
            }
            IJobManager jobManager = (IJobManager)runtimeContext.get(IJobManager.class);
            if (jobManager.getJob(jobId) == null) {
                jobManager.createJob(jobTypeId, jobId, parameter);
            }
            if ((queue = (queueService = JobsActivator.getInstance().getQueueService()).getQueue("gyrex.jobs.queue.default", null)) == null) {
                queueService.createQueue("gyrex.jobs.queue.default", null);
            }
            jobManager.queueJob(jobId, "gyrex.jobs.queue.default");
        }
        catch (Exception e) {
            throw new JobExecutionException(String.format("Error queuing job '%s'. %s", jobId, e.getMessage()), (Throwable)e);
        }
    }
}

