/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.eclipse.gyrex.common.identifiers.IdHelper;

public class JobInfo {
    private static final String PREFIX = "gyrex.jobinfo.";
    private static final String ID = "gyrex.jobinfo.jobid";
    private static final String TYPE_ID = "gyrex.jobinfo.jobtype";
    private static final String CONTEXT_PATH = "gyrex.jobinfo.jobcontext";
    private static final String VERSION = "gyrex.jobinfo.version";
    private static final String VERSION_VALUE = "1";
    private final String jobId;
    private final String jobTypeId;
    private final Map<String, String> jobProperties;
    private final IPath contextPath;

    public static byte[] asMessage(JobInfo info) throws IOException {
        Properties properties = new Properties();
        Map<String, String> jobProperties = info.getJobProperties();
        for (String key : jobProperties.keySet()) {
            properties.put(key, jobProperties.get(key));
        }
        properties.put(VERSION, VERSION_VALUE);
        properties.put(ID, info.getJobId());
        properties.put(TYPE_ID, info.getJobTypeId());
        properties.put(CONTEXT_PATH, info.getContextPath().toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        properties.store((OutputStream)out, null);
        return out.toByteArray();
    }

    public static JobInfo parse(IMessage message) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(message.getBody()));
        Object versionValue = properties.remove(VERSION);
        if (!VERSION_VALUE.equals(versionValue)) {
            throw new IOException(String.format("invalid record data: version mismatch (expected %d, found %s)", 1, String.valueOf(versionValue)));
        }
        Object jobIdValue = properties.remove(ID);
        if (jobIdValue == null || !(jobIdValue instanceof String) || !IdHelper.isValidId((String)((String)jobIdValue))) {
            throw new IOException(String.format("invalid record data: missing/invalid job id %s", String.valueOf(jobIdValue)));
        }
        Object jobTypeValue = properties.remove(TYPE_ID);
        if (jobTypeValue == null || !(jobTypeValue instanceof String) || !IdHelper.isValidId((String)((String)jobTypeValue))) {
            throw new IOException(String.format("invalid record data: missing/invalid job id %s", String.valueOf(jobTypeValue)));
        }
        Object contextPathValue = properties.remove(CONTEXT_PATH);
        if (contextPathValue == null || !(contextPathValue instanceof String) || !Path.EMPTY.isValidPath((String)contextPathValue)) {
            throw new IOException(String.format("invalid record data: missing/invalid context path %s", String.valueOf(contextPathValue)));
        }
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        for (String string : properties.keySet()) {
            if (string.startsWith(PREFIX)) continue;
            jobProperties.put(string, properties.getProperty(string));
        }
        return new JobInfo((String)jobTypeValue, (String)jobIdValue, (IPath)new Path((String)contextPathValue), jobProperties);
    }

    public JobInfo(String jobTypeId, String jobId, IPath contextPath, Map<String, String> jobProperties) {
        this.jobId = jobId;
        this.jobTypeId = jobTypeId;
        this.contextPath = contextPath;
        this.jobProperties = jobProperties;
    }

    public IPath getContextPath() {
        return this.contextPath;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    public String getJobTypeId() {
        return this.jobTypeId;
    }
}

