/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.IJobContext;

public abstract class JobProvider
extends PlatformObject {
    public static final String SERVICE_NAME = JobProvider.class.getName();
    private final List<String> providedTypeIds;

    protected JobProvider(Collection<String> providedTypeIds) {
        if (providedTypeIds == null || providedTypeIds.isEmpty()) {
            throw new IllegalArgumentException("job types must not be null or empty");
        }
        this.providedTypeIds = new ArrayList<String>(providedTypeIds.size());
        for (String id : providedTypeIds) {
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException(String.format("type id \"%s\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", id));
            }
            this.providedTypeIds.add(id);
        }
    }

    public abstract Job createJob(String var1, IJobContext var2) throws Exception;

    public final Collection<String> getProvidedTypeIds() {
        return Collections.unmodifiableCollection(this.providedTypeIds);
    }

    public final String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " [" + StringUtils.join(this.providedTypeIds, (char)',') + "]";
    }
}

