/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.model.common.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.model.common.provider.BaseModelManager;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.persistence.storage.Repository;

public abstract class BaseModelManagerMetrics
extends MetricSet {
    protected static String createDescription(String managerImplementationName, IRuntimeContext context, Repository repository) {
        return String.format("Metrics for %s in context %s backed by repository %s.", managerImplementationName, context.getContextPath(), repository.getRepositoryId());
    }

    protected static Map<String, String> createProperties(Class<? extends BaseModelManager<?>> managerClass, IRuntimeContext context, Repository repository) {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("manager.class", managerClass.getName());
        properties.put("context.path", context.getContextPath().toString());
        properties.put("repository.id", repository.getRepositoryId());
        properties.put("repository.provider.id", repository.getRepositoryProvider().getProviderId());
        return properties;
    }

    protected BaseModelManagerMetrics(String id, Class<? extends BaseModelManager<?>> managerClass, IRuntimeContext context, Repository repository, BaseMetric ... metrics) {
        super(id, BaseModelManagerMetrics.createDescription(managerClass.getSimpleName(), context, repository), BaseModelManagerMetrics.createProperties(managerClass, context, repository), metrics);
    }

    protected BaseModelManagerMetrics(String id, String description, Map<String, String> properties, BaseMetric ... metrics) {
        super(id, description, properties, metrics);
    }
}

