/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.model.common.provider;

import java.util.ArrayList;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.provider.RuntimeContextObjectProvider;
import org.eclipse.gyrex.model.common.IModelManager;
import org.eclipse.gyrex.model.common.provider.BaseModelManager;
import org.eclipse.gyrex.persistence.PersistenceUtil;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.osgi.util.NLS;

public abstract class ModelProvider
extends RuntimeContextObjectProvider {
    private final Class[] providedManagers;
    private final RepositoryContentType contentType;

    protected ModelProvider(RepositoryContentType contentType, Class ... providedManagers) throws IllegalArgumentException {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType must not be null");
        }
        if (providedManagers == null) {
            throw new IllegalArgumentException("providedManagers must not be null");
        }
        if (providedManagers.length == 0) {
            throw new IllegalArgumentException("providedManagers must contain at least one entry");
        }
        ArrayList<Class> managers = new ArrayList<Class>(providedManagers.length);
        Class[] classArray = providedManagers;
        int n = providedManagers.length;
        int n2 = 0;
        while (n2 < n) {
            Class manager = classArray[n2];
            if (manager == null) {
                throw new IllegalArgumentException("providedManagers list contains NULL entries which is not supported");
            }
            if (!IModelManager.class.isAssignableFrom(manager)) {
                throw new IllegalArgumentException("manager '" + manager.getName() + "' is not assignable to '" + IModelManager.class.getName() + "'");
            }
            managers.add(manager);
            ++n2;
        }
        this.providedManagers = managers.toArray(new Class[managers.size()]);
        this.contentType = contentType;
    }

    public abstract BaseModelManager createModelManagerInstance(Class var1, Repository var2, IRuntimeContext var3);

    public final RepositoryContentType getContentType() {
        return this.contentType;
    }

    public <T> T getObject(Class<T> type, IRuntimeContext context) throws IllegalStateException {
        Repository repository = PersistenceUtil.getRepository((IRuntimeContext)context, (RepositoryContentType)this.getContentType());
        BaseModelManager manager = this.createModelManagerInstance(type, repository, context);
        if (manager == null) {
            return null;
        }
        if (!type.isInstance(manager)) {
            throw new IllegalStateException(NLS.bind((String)"Unable to return object of type {0} for context {1}; manager ({2}) of type {3} does not implement {0}", (Object[])new Object[]{type.getName(), context.getContextPath().toString(), manager.toString(), manager.getClass().getName()}));
        }
        return type.cast(manager);
    }

    public final Class<?>[] getObjectTypes() {
        return this.providedManagers;
    }

    public final void ungetObject(Object object, IRuntimeContext context) {
        if (object instanceof BaseModelManager) {
            ((BaseModelManager)object).close();
        }
    }
}

