/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal;

import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.p2.internal.P2Debug;
import org.eclipse.gyrex.p2.internal.PackageManager;
import org.eclipse.gyrex.p2.internal.RepoManager;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class P2Activator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.p2";
    private static volatile P2Activator instance;
    private volatile PackageManager packageManager;
    private volatile RepoManager repoManager;
    private volatile IPath configLocationPath;

    public static P2Activator getInstance() {
        P2Activator activator = instance;
        if (activator == null) {
            throw new IllegalArgumentException("inactive");
        }
        return activator;
    }

    public P2Activator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instance = this;
        this.packageManager = new PackageManager();
        this.repoManager = new RepoManager();
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
        this.packageManager = null;
        this.repoManager = null;
    }

    public IPath getConfigLocation() {
        Collection serviceReferences;
        if (this.configLocationPath != null) {
            return this.configLocationPath;
        }
        BundleContext context = this.getBundle().getBundleContext();
        try {
            serviceReferences = context.getServiceReferences(Location.class, Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("error determining configuration location: " + e.getMessage(), e);
        }
        Location userConfigLocation = (Location)context.getService((ServiceReference)serviceReferences.iterator().next());
        if (userConfigLocation.isReadOnly()) {
            throw new IllegalStateException("config location is read-only");
        }
        URL url = userConfigLocation.getURL();
        if (url == null) {
            throw new IllegalStateException("config location not available");
        }
        if (!url.getProtocol().equals("file")) {
            throw new IllegalStateException("config location must be on local file system");
        }
        this.configLocationPath = new Path(url.getPath());
        return this.configLocationPath;
    }

    protected Class getDebugOptions() {
        return P2Debug.class;
    }

    public IPackageManager getPackageManager() {
        PackageManager manager = this.packageManager;
        if (manager == null) {
            throw this.createBundleInactiveException();
        }
        return manager;
    }

    public IRepositoryDefinitionManager getRepositoryManager() {
        RepoManager manager = this.repoManager;
        if (manager == null) {
            throw this.createBundleInactiveException();
        }
        return manager;
    }
}

