/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.installer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallState;

public class InstallLog {
    private final String sessionId;
    private final File logFile;
    private final PrintWriter logFileWriter;
    private final Date creationDate;

    private static File createNewLog(IPath logsFolder, String baseName) throws IOException {
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            File logFile = logsFolder.append(baseName).addFileExtension(String.valueOf(i) + ".log").toFile();
            if (!logFile.exists()) {
                FileUtils.forceMkdir((File)logFile.getParentFile());
                if (logFile.createNewFile()) {
                    return logFile;
                }
            }
            ++i;
        }
        return null;
    }

    public InstallLog(String sessionId) throws IOException {
        this.sessionId = sessionId;
        this.creationDate = new Date();
        IPath logsFolder = PackageInstallState.getBaseLocation().append("logs");
        String baseName = "install-" + DateFormatUtils.ISO_DATE_FORMAT.format(this.creationDate);
        File logFile = InstallLog.createNewLog(logsFolder, baseName);
        if (logFile == null) {
            throw new IllegalStateException("unable to create new log file; file count limit exceeded");
        }
        this.logFile = logFile;
        this.logFileWriter = new PrintWriter((Writer)new FileWriterWithEncoding(logFile, "UTF-16"));
        this.writeHeader();
    }

    public void canceled() {
        this.logFileWriter.println();
        this.logFileWriter.println("Installation canceled by operator.");
    }

    public void close() {
        this.writeFooter();
        this.logFileWriter.flush();
        this.logFileWriter.close();
    }

    public void logConfiguration(URL urlInUse) {
        this.logFileWriter.println();
        this.logFileWriter.println("Software Configuration");
        this.logFileWriter.println("----------------------");
        this.logFileWriter.println("URL: " + urlInUse.toString());
        this.logFileWriter.println("<snip>");
        InputStream in = null;
        try {
            in = urlInUse.openStream();
            this.logFileWriter.println(IOUtils.toString((InputStream)in));
        }
        catch (IOException e) {
            this.logFileWriter.println(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        this.logFileWriter.println("</snip>");
    }

    public void logInstallStatus(InstallOperation op, IStatus result) {
        this.logFileWriter.println();
        this.logFileWriter.println("Software Installation");
        this.logFileWriter.println("----------------------");
        this.printStatus(result, "");
        this.logFileWriter.println(op.getResolutionDetails());
        if (result.getCode() == 10000) {
            this.logFileWriter.println();
            this.logFileWriter.println("Nothing to install.");
        } else if (result.matches(12)) {
            this.logFileWriter.println();
            this.logFileWriter.println("Software installation not possible.");
        } else if (!result.isOK()) {
            this.logFileWriter.println();
            this.logFileWriter.println("Install operation resolved with warnings. An installation will be forced.");
        }
    }

    public void logRepositories(IMetadataRepositoryManager metadataRepositoryManager, IArtifactRepositoryManager artifactRepositoryManager) {
        this.logFileWriter.println();
        this.logFileWriter.println("Software Repositories");
        this.logFileWriter.println("---------------------");
        this.logFileWriter.println();
        this.logFileWriter.println("Metadata Repositories:");
        this.printRepositories((IRepositoryManager)metadataRepositoryManager);
        this.logFileWriter.println();
        this.logFileWriter.println("Artifact Repositories:");
        this.printRepositories((IRepositoryManager)metadataRepositoryManager);
    }

    public void logRepositories(URI[] repositories) {
        this.logFileWriter.println();
        this.logFileWriter.println("Software Repositories");
        this.logFileWriter.println("---------------------");
        this.logFileWriter.println();
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            this.logFileWriter.print("  ");
            this.logFileWriter.println(uri.toString());
            ++n2;
        }
    }

    public void logUninstallStatus(UninstallOperation op, IStatus result) {
        this.logFileWriter.println();
        this.logFileWriter.println("Software Removal");
        this.logFileWriter.println("----------------");
        this.printStatus(result, "");
        this.logFileWriter.println(op.getResolutionDetails());
        if (result.matches(12)) {
            this.logFileWriter.println();
            this.logFileWriter.println("Software removal not possible.");
        } else if (!result.isOK()) {
            this.logFileWriter.println();
            this.logFileWriter.println("Uninstall operation resolved with warnings. An uninstallation will be forced.");
        }
    }

    public void nothingToAdd() {
        this.logFileWriter.println();
        this.logFileWriter.println("No new packages to install.");
    }

    public void nothingToRemove() {
        this.logFileWriter.println();
        this.logFileWriter.println("No revoked packages to remove.");
    }

    private void printRepositories(IRepositoryManager repositoryManager) {
        URI[] knownRepositories;
        URI[] uRIArray = knownRepositories = repositoryManager.getKnownRepositories(0);
        int n = knownRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            boolean enabled = repositoryManager.isEnabled(uri);
            String nickName = repositoryManager.getRepositoryProperty(uri, "p2.nickname");
            this.logFileWriter.print("  ");
            this.logFileWriter.print(uri.toString());
            if (nickName != null) {
                this.logFileWriter.print(" (");
                this.logFileWriter.print(nickName);
                this.logFileWriter.print(")");
            }
            if (!enabled) {
                this.logFileWriter.print(" (disabled)");
            }
            this.logFileWriter.println();
            ++n2;
        }
    }

    private void printStatus(IStatus status, String ident) {
        if (StringUtils.isNotBlank((String)status.getMessage())) {
            this.logFileWriter.print(ident);
            this.logFileWriter.print(status.getMessage());
            if (status.getException() != null) {
                this.logFileWriter.print(" (");
                this.logFileWriter.print(ExceptionUtils.getRootCauseMessage((Throwable)status.getException()));
                this.logFileWriter.print(")");
            }
            this.logFileWriter.println();
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            String childIdent = StringUtils.isNotBlank((String)status.getMessage()) ? String.valueOf(ident) + "  " : ident;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.printStatus(child, childIdent);
                ++n2;
            }
        }
    }

    public void recoveredSession(String recoveredInstallSessionId) {
        this.logFileWriter.println();
        this.logFileWriter.println("Continuing with previous installation session");
    }

    public void restart() {
        this.logFileWriter.println();
        this.logFileWriter.println("Restarting system. Installation will continue afterwards.");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InstallLog [sessionId=").append(this.sessionId).append(", logFile=").append(this.logFile).append("]");
        return builder.toString();
    }

    private void writeFooter() {
        this.logFileWriter.println();
        this.logFileWriter.println();
        this.logFileWriter.println("<EOF>");
    }

    private void writeHeader() {
        this.logFileWriter.println("Installation Log");
        this.logFileWriter.println("================");
        this.logFileWriter.println();
        this.logFileWriter.println("Created: " + DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.creationDate));
        this.logFileWriter.println("   Node: " + ((INodeEnvironment)P2Activator.getInstance().getService(INodeEnvironment.class)).getNodeId());
        this.logFileWriter.println("Session: " + this.sessionId);
        this.logFileWriter.println("   Path: " + this.logFile.getPath());
        this.logFileWriter.println();
        this.logFileWriter.println();
    }
}

