/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.installer;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.cloud.services.locking.IDurableLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.P2Debug;
import org.eclipse.gyrex.p2.internal.installer.InstallLog;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallState;
import org.eclipse.gyrex.p2.internal.installer.ProvisioningHelper;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.gyrex.p2.internal.repositories.RepoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageInstallerJob
extends Job {
    public static final String ID_INSTALL_LOCK = "org.eclipse.gyrex.p2".concat(".install.lock");
    public static final Logger LOG = LoggerFactory.getLogger(PackageInstallerJob.class);
    private final ILockMonitor<IDurableLock> lockMonitor = new ILockMonitor<IDurableLock>(){

        public void lockAcquired(IDurableLock lock) {
        }

        public void lockLost(IDurableLock lock) {
            LOG.warn("Lost global installation lock. Aborting installation.");
            PackageInstallerJob.this.cancel();
        }

        public void lockReleased(IDurableLock lock) {
        }
    };
    private final Set<PackageDefinition> packagesToInstall;
    private final Set<PackageDefinition> packagesToRemove;
    private IDurableLock lock;
    private ProvisioningHelper provisioningHelper;

    PackageInstallerJob(Set<PackageDefinition> packagesToInstall, Set<PackageDefinition> packagesToRemove) {
        super("Software Package Installer");
        this.packagesToInstall = packagesToInstall;
        this.packagesToRemove = packagesToRemove;
        this.setSystem(true);
        this.setPriority(30);
        this.setRule(new MutexRule(PackageInstallerJob.class));
    }

    private void checkLock() {
        if (!this.lock.isValid()) {
            throw new OperationCanceledException();
        }
    }

    private int install(PackageDefinition installPackage, IProvisioningAgent agent, InstallLog installLog) {
        if (P2Debug.nodeInstallation) {
            LOG.debug("Installing package: {}", (Object)installPackage);
        }
        URI[] repositories = RepoUtil.getFilteredRepositories();
        installLog.logRepositories(repositories);
        IInstallableUnit packageUnit = PackageInstallState.createUnit(installPackage);
        this.checkLock();
        InstallOperation op = this.provisioningHelper.getInstallOperation(Collections.singletonList(packageUnit), repositories);
        if (P2Debug.nodeInstallation) {
            LOG.debug("Resolving p2 install operation for package {}...", (Object)installPackage);
        }
        IStatus result = op.resolveModal(null);
        if (P2Debug.nodeInstallation) {
            LOG.debug("Resolved p2 install operation for package {}: {}", (Object)installPackage, (Object)op.getResolutionDetails());
        }
        installLog.logInstallStatus(op, result);
        if (result.getCode() == 10000) {
            LOG.warn("Nothing to update.");
            return 1;
        }
        if (result.matches(12)) {
            LOG.warn("Install operation not possible. {}", (Object)op.getResolutionDetails());
            throw new IllegalStateException("Install operation not possible. " + op.getResolutionDetails());
        }
        if (!result.isOK()) {
            LOG.warn("Install operation resolved with warnings. An installation will be forced. {}", (Object)op.getResolutionDetails());
        }
        this.checkLock();
        if (P2Debug.nodeInstallation) {
            LOG.debug("Performing installation of package {}...", (Object)installPackage);
        }
        ProvisioningJob job = op.getProvisioningJob(null);
        IStatus installResult = job.runModal(null);
        if (!result.isOK()) {
            LOG.warn("Install operation failed. {}", (Object)installResult.getMessage());
            throw new IllegalStateException("Install operation failed. " + installResult.getMessage(), installResult.getException());
        }
        return job.getRestartPolicy();
    }

    private int remove(PackageDefinition packageDefinition, IProvisioningAgent agent, InstallLog installLog) {
        if (P2Debug.nodeInstallation) {
            LOG.debug("Uninstalling package: {}", (Object)packageDefinition);
        }
        URI[] repositories = RepoUtil.getFilteredRepositories();
        installLog.logRepositories(repositories);
        IInstallableUnit packageUnit = PackageInstallState.createUnit(packageDefinition);
        this.checkLock();
        UninstallOperation op = this.provisioningHelper.getUninstallOperation(Collections.singletonList(packageUnit), repositories);
        if (P2Debug.nodeInstallation) {
            LOG.debug("Resolving p2 uninstall operation for package {}...", (Object)packageDefinition);
        }
        IStatus result = op.resolveModal(null);
        if (P2Debug.nodeInstallation) {
            LOG.debug("Resolved p2 uninstall operation for package {}: {}", (Object)packageDefinition, (Object)op.getResolutionDetails());
        }
        installLog.logUninstallStatus(op, result);
        if (result.matches(12)) {
            LOG.warn("Uninstall operation not possible. {}", (Object)op.getResolutionDetails());
            throw new IllegalStateException("Install operation not possible. " + op.getResolutionDetails());
        }
        if (!result.isOK()) {
            LOG.warn("Uninstall operation resolved with warnings. An installation will be forced. {}", (Object)op.getResolutionDetails());
        }
        this.checkLock();
        if (P2Debug.nodeInstallation) {
            LOG.debug("Performing installation of package {}...", (Object)packageDefinition);
        }
        ProvisioningJob job = op.getProvisioningJob(null);
        IStatus installResult = job.runModal(null);
        if (!result.isOK()) {
            LOG.warn("Install operation failed. {}", (Object)installResult.getMessage());
            throw new IllegalStateException("Install operation failed. " + installResult.getMessage(), installResult.getException());
        }
        return job.getRestartPolicy();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        activeSessionId = PackageInstallState.getActiveInstallSessionId();
        PackageInstallerJob.LOG.info("Software installation started. Checking for global installation lock.");
        lockService = (ILockService)P2Activator.getInstance().getService(ILockService.class);
        if (activeSessionId != null) {
            if (P2Debug.nodeInstallation) {
                PackageInstallerJob.LOG.debug("Recovering active installation session.");
            }
            try {
                this.lock = lockService.recoverDurableLock(PackageInstallerJob.ID_INSTALL_LOCK, this.lockMonitor, activeSessionId);
            }
            catch (IllegalStateException e) {
                PackageInstallerJob.LOG.warn("Unable to recover installation session. Please intervent manually! {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                return Status.CANCEL_STATUS;
            }
        }
        if (this.lock == null) {
            if (P2Debug.nodeInstallation) {
                PackageInstallerJob.LOG.debug("Starting new installation session.");
            }
            try {
                this.lock = lockService.acquireDurableLock(PackageInstallerJob.ID_INSTALL_LOCK, this.lockMonitor, TimeUnit.SECONDS.toMillis(5L));
            }
            catch (InterruptedException v0) {
                Thread.currentThread().interrupt();
                PackageInstallerJob.LOG.info("Installation canceled while waiting for install lock. Aborting current installation.");
                return Status.CANCEL_STATUS;
            }
            catch (TimeoutException v1) {
                PackageInstallerJob.LOG.info("Concurrent installation in progress on a differnt node. Aborting current installation.");
                return Status.CANCEL_STATUS;
            }
        }
        installLog = null;
        agent = null;
        try {
            block29: {
                block28: {
                    recoveredInstallSessionId = activeSessionId;
                    activeSessionId = this.lock.getRecoveryKey();
                    PackageInstallState.setActiveInstallSessionId(activeSessionId);
                    installLog = new InstallLog(activeSessionId);
                    if (recoveredInstallSessionId != null) {
                        installLog.recoveredSession(recoveredInstallSessionId);
                    }
                    this.checkLock();
                    agent = ((IProvisioningAgentProvider)P2Activator.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(null);
                    if (agent == null) {
                        throw new IllegalStateException("The current system has not been provisioned using p2. Unable to acquire provisioning agent.");
                    }
                    this.provisioningHelper = new ProvisioningHelper(new ProvisioningSession(agent), "_SELF_");
                    configurator = (Configurator)P2Activator.getInstance().getService(Configurator.class);
                    installLog.logConfiguration(configurator.getUrlInUse());
                    this.checkLock();
                    if (this.packagesToRemove.isEmpty()) break block28;
                    var9_10 = this.packagesToRemove.iterator();
                    if (true) ** GOTO lbl56
                }
                installLog.nothingToRemove();
                break block29;
                do {
                    if ((restartPolicy = this.remove(packageDefinition = var9_10.next(), agent, installLog)) != 3) continue;
                    PackageInstallerJob.LOG.warn("Restart required after un-installing package {}. Restarting now.", (Object)packageDefinition);
                    installLog.restart();
                    this.scheduleRestart();
                    var12_13 = Status.OK_STATUS;
                    return var12_13;
lbl56:
                    // 2 sources

                } while (var9_10.hasNext());
            }
            if (this.packagesToInstall.isEmpty()) ** GOTO lbl-1000
            var9_10 = this.packagesToInstall.iterator();
            if (true) ** GOTO lbl70
lbl-1000:
            // 1 sources

            {
                block30: {
                    installLog.nothingToAdd();
                    break block30;
                    do {
                        if ((restartPolicy = this.install(packageDefinition = var9_10.next(), agent, installLog)) == 3) {
                            PackageInstallerJob.LOG.warn("Restart required after installing package {}. Restarting now.", (Object)packageDefinition);
                            installLog.restart();
                            this.scheduleRestart();
                            var12_14 = Status.OK_STATUS;
                            return var12_14;
                        }
lbl70:
                        // 3 sources

                        ** try [egrp 5[TRYBLOCK] [5, 8 : 575->651)] { 
lbl71:
                        // 1 sources

                    } while (var9_10.hasNext());
                }
                if (P2Debug.nodeInstallation) {
                    PackageInstallerJob.LOG.info("Applying new software configuration. {}", (Object)configurator.getUrlInUse());
                }
                installLog.logConfiguration(configurator.getUrlInUse());
                configurator.applyConfiguration();
                PackageInstallState.removeActiveInstallSessionId();
                this.lock.release();
                return Status.OK_STATUS;
            }
        }
lbl80:
        // 2 sources

        catch (OperationCanceledException v2) {
            PackageInstallerJob.LOG.warn("Software installation canceled.");
            PackageInstallState.removeActiveInstallSessionId();
            if (this.lock.isValid()) {
                this.lock.release();
            }
            if (installLog != null) {
                installLog.canceled();
            }
            var12_15 = Status.CANCEL_STATUS;
            return var12_15;
        }
lbl89:
        // 2 sources

        catch (Exception e) {
            PackageInstallerJob.LOG.error("Error during software installation. Please check installation log ({}). {}", new Object[]{installLog, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            var12_16 = Status.CANCEL_STATUS;
            return var12_16;
        }
        finally {
            if (installLog != null) {
                installLog.close();
            }
            this.provisioningHelper = null;
            if (agent != null) {
                agent.stop();
            }
            this.lock = null;
        }
    }

    private void scheduleRestart() {
        Job restartJob = new Job("Restarting"){

            protected IStatus run(IProgressMonitor monitor) {
                ServerApplication.restart();
                return Status.OK_STATUS;
            }
        };
        restartJob.setSystem(true);
        restartJob.setPriority(20);
        restartJob.schedule(500L);
    }

    static class MutexRule
    implements ISchedulingRule {
        private final Object object;

        public MutexRule(Object object) {
            this.object = object;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.object.equals(((MutexRule)rule).object);
            }
            return false;
        }
    }
}

