/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.installer;

import java.net.URI;
import java.util.Collection;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;

public class ProvisioningHelper {
    private final ProvisioningSession session;
    private String profileId;

    public ProvisioningHelper(ProvisioningSession session, String profileId) {
        this.profileId = profileId;
        if (profileId == null) {
            this.profileId = "_SELF_";
        }
        this.session = session;
    }

    public InstallOperation getInstallOperation(Collection<IInstallableUnit> iusToInstall, URI[] repositories) {
        InstallOperation op = new InstallOperation(this.getSession(), iusToInstall);
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.makeProvisioningContext(repositories));
        return op;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public RepositoryTracker getRepositoryTracker() {
        return (RepositoryTracker)this.session.getProvisioningAgent().getService(RepositoryTracker.class.getName());
    }

    public ProvisioningSession getSession() {
        return this.session;
    }

    public UninstallOperation getUninstallOperation(Collection<IInstallableUnit> iusToUninstall, URI[] repositories) {
        UninstallOperation op = new UninstallOperation(this.getSession(), iusToUninstall);
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.makeProvisioningContext(repositories));
        return op;
    }

    public UpdateOperation getUpdateOperation(Collection<IInstallableUnit> iusToUpdate, URI[] repositories) {
        UpdateOperation op = new UpdateOperation(this.getSession(), iusToUpdate);
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.makeProvisioningContext(repositories));
        return op;
    }

    public boolean hasScheduledOperations() {
        return this.getSession().hasScheduledOperationsFor(this.profileId);
    }

    private ProvisioningContext makeProvisioningContext(URI[] repos) {
        if (repos != null) {
            ProvisioningContext context = new ProvisioningContext(this.getSession().getProvisioningAgent());
            context.setMetadataRepositories(repos);
            context.setArtifactRepositories(repos);
            return context;
        }
        return new ProvisioningContext(this.getSession().getProvisioningAgent());
    }
}

