/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.derby.internal;

import java.io.File;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.osgi.framework.BundleContext;

public class DerbyActivator
extends BaseBundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.gyrex.persistence.derby";
    private static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";

    public DerbyActivator() {
        super(PLUGIN_ID);
    }

    protected void doStart(BundleContext context) throws Exception {
        File systemBase = context.getDataFile("derbysystembase");
        if (systemBase == null) {
            throw new IllegalStateException("The framework must have file system support to use the Derby persistence type.");
        }
        System.setProperty("derby.system.home", systemBase.getPath());
        try {
            this.getBundle().loadClass(DERBY_EMBEDDED_DRIVER).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load Derby database driver: " + e.getMessage());
        }
    }
}

