/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.net.MalformedURLException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.eclipse.gyrex.persistence.solr.SolrServerRepository;
import org.eclipse.gyrex.persistence.solr.config.SolrServerType;
import org.eclipse.gyrex.persistence.solr.internal.SolrActivator;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepository;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;

public class SolrRepositoryProvider
extends RepositoryProvider {
    public static final String PREF_KEY_SERVER_TYPE = "serverType";
    public static final String PREF_KEY_SERVER_URL = "serverUrl";
    private final CoreContainer coreContainer;

    public SolrRepositoryProvider(CoreContainer coreContainer) {
        super("org.eclipse.gyrex.persistence.solr", SolrServerRepository.class);
        this.coreContainer = coreContainer;
    }

    private SolrServer createReadServer(String urlString) throws MalformedURLException {
        CommonsHttpSolrServer solrServerForRead = new CommonsHttpSolrServer(urlString);
        solrServerForRead.setConnectionTimeout(1000);
        solrServerForRead.setConnectionManagerTimeout(1000L);
        solrServerForRead.setSoTimeout(5000);
        return solrServerForRead;
    }

    public Repository createRepositoryInstance(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        return new SolrRepository(repositoryId, this, this.createServers(repositoryId, repositoryPreferences));
    }

    private SolrServer[] createServers(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        SolrServer[] servers;
        String typeStr = repositoryPreferences.get(PREF_KEY_SERVER_TYPE, null);
        SolrServerType serverType = typeStr == null ? SolrServerType.EMBEDDED : SolrServerType.valueOf(typeStr);
        switch (serverType) {
            case EMBEDDED: {
                SolrServer embeddedServer = this.getEmbeddedServer(repositoryId);
                servers = new SolrServer[]{embeddedServer, embeddedServer};
                break;
            }
            case REMOTE: {
                String urlString = repositoryPreferences.get(PREF_KEY_SERVER_URL, null);
                try {
                    servers = new SolrServer[]{new CommonsHttpSolrServer(urlString), this.createReadServer(urlString)};
                    break;
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(String.format("Repository %s not configured correctly. Server URL '%s' is invalid.  %s", repositoryId, urlString, e.getMessage()));
                }
            }
            default: {
                throw new IllegalStateException(String.format("Repository %s not configured correctly. Unsupported server type %s", repositoryId, typeStr));
            }
        }
        return servers;
    }

    private SolrServer getEmbeddedServer(String repositoryId) {
        String coreName = SolrActivator.getEmbeddedSolrCoreName(repositoryId);
        SolrCore core = this.coreContainer.getCore(coreName);
        if (core == null) {
            throw new IllegalStateException("Solr core '" + coreName + "' not found");
        }
        core.close();
        return new EmbeddedSolrServer(this.coreContainer, coreName);
    }
}

