/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal;

import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.persistence.internal.storage.ContentTypeTracker;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryProviderRegistry;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryRegistry;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PersistenceActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.persistence";
    private static PersistenceActivator sharedInstance;
    private volatile RepositoryProviderRegistry repositoryProviderRegistry;
    private volatile RepositoryRegistry repositoryRegistry;
    private volatile ContentTypeTracker contentTypeTracker;
    private ServiceRegistration repositoryRegistryRegistration;

    public static PersistenceActivator getInstance() {
        PersistenceActivator instance = sharedInstance;
        if (instance == null) {
            throw new IllegalStateException("The Persistence bundle has not been started.");
        }
        return instance;
    }

    public PersistenceActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        sharedInstance = this;
        this.contentTypeTracker = new ContentTypeTracker(context);
        this.contentTypeTracker.open();
        this.repositoryProviderRegistry = new RepositoryProviderRegistry();
        this.repositoryProviderRegistry.start(context);
        this.repositoryRegistry = new RepositoryRegistry();
        this.repositoryRegistryRegistration = this.getServiceHelper().registerService(IRepositoryRegistry.class.getName(), (Object)this.repositoryRegistry, "Eclipse.org", "Gyrex Repository Registry", null, null);
    }

    protected void doStop(BundleContext context) throws Exception {
        sharedInstance = null;
        this.repositoryRegistryRegistration.unregister();
        this.repositoryRegistryRegistration = null;
        this.repositoryRegistry.close();
        this.repositoryRegistry = null;
        this.repositoryProviderRegistry.close();
        this.repositoryProviderRegistry = null;
        this.contentTypeTracker.close();
        this.contentTypeTracker = null;
    }

    public ContentTypeTracker getContentTypeTracker() {
        ContentTypeTracker tracker = this.contentTypeTracker;
        if (tracker == null) {
            throw this.createBundleInactiveException();
        }
        return tracker;
    }

    public RepositoryRegistry getRepositoriesManager() {
        RepositoryRegistry registry = this.repositoryRegistry;
        if (registry == null) {
            throw this.createBundleInactiveException();
        }
        return registry;
    }

    public RepositoryProviderRegistry getRepositoryProviderRegistry() {
        RepositoryProviderRegistry registry = this.repositoryProviderRegistry;
        if (registry == null) {
            throw this.createBundleInactiveException();
        }
        return registry;
    }
}

