/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;

public final class RepositoryPreferences
implements IRepositoryPreferences {
    private final IEclipsePreferences prefs;

    public RepositoryPreferences(IEclipsePreferences prefs) {
        this.prefs = prefs;
    }

    @Override
    public void flush() throws BackingStoreException {
        this.prefs.flush();
    }

    @Override
    public String get(String key, String defaultValue) {
        String[] decodePath = EclipsePreferencesUtil.decodePath((String)key);
        String path = decodePath[0];
        IEclipsePreferences node = path == null ? this.prefs : this.prefs.node(EclipsePreferencesUtil.makeRelative((String)path));
        return node.get(decodePath[1], defaultValue);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String result = this.get(key, null);
        return result == null ? defaultValue : Boolean.valueOf(result);
    }

    @Override
    public byte[] getByteArray(String key, byte[] defaultValue) throws SecurityException {
        String value = this.get(key, null);
        try {
            return value == null ? defaultValue : Base64.decodeBase64((byte[])value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Gyrex requires a platform which supports UTF-8.", e);
        }
    }

    @Override
    public String[] getChildrenNames(String path) throws BackingStoreException, SecurityException, IllegalStateException {
        return this.prefs.node(EclipsePreferencesUtil.makeRelative((String)path)).childrenNames();
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        String value = this.get(key, null);
        return NumberUtils.toFloat((String)value, (float)defaultValue);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.get(key, null);
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    @Override
    public String[] getKeys(String path) throws BackingStoreException, SecurityException, IllegalStateException {
        return this.prefs.node(EclipsePreferencesUtil.makeRelative((String)path)).keys();
    }

    @Override
    public void put(String key, String value, boolean encrypt) throws SecurityException {
        String[] decodePath = EclipsePreferencesUtil.decodePath((String)key);
        String path = decodePath[0];
        IEclipsePreferences node = path == null ? this.prefs : this.prefs.node(EclipsePreferencesUtil.makeRelative((String)path));
        node.put(decodePath[1], value);
    }

    @Override
    public void putBoolean(String key, boolean value, boolean encrypt) {
        this.put(key, Boolean.toString(value), encrypt);
    }

    @Override
    public void putByteArray(String key, byte[] value, boolean encrypt) throws SecurityException {
        try {
            this.put(key, new String(Base64.encodeBase64((byte[])value), "UTF-8"), encrypt);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Gyrex requires a platform which supports UTF-8.", e);
        }
    }

    @Override
    public void putFloat(String key, float value, boolean encrypt) {
        this.put(key, Float.toString(value), encrypt);
    }

    @Override
    public void putInt(String key, int value, boolean encrypt) throws SecurityException {
        this.put(key, Integer.toString(value), encrypt);
    }

    @Override
    public void remove(String key) {
        String[] decodePath = EclipsePreferencesUtil.decodePath((String)key);
        String path = decodePath[0];
        IEclipsePreferences node = path == null ? this.prefs : this.prefs.node(EclipsePreferencesUtil.makeRelative((String)path));
        try {
            if (node.nodeExists(decodePath[1])) {
                node.node(decodePath[1]).removeNode();
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to remove node %s. %s", key, e.getMessage()), e);
        }
        node.remove(decodePath[1]);
    }

    @Override
    public void sync() throws BackingStoreException {
        this.prefs.sync();
    }
}

