/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.storage;

import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryPreferencesBasedMetadata;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryRegistry;
import org.eclipse.gyrex.persistence.storage.IRepositoryContstants;
import org.eclipse.gyrex.persistence.storage.RepositoryMetadata;
import org.eclipse.gyrex.persistence.storage.content.BasicRepositoryContentTypeSupport;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentTypeSupport;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryDefinition;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public abstract class Repository
extends PlatformObject
implements IRepositoryContstants {
    private final String repositoryId;
    private final RepositoryProvider repositoryProvider;
    private volatile boolean closed;
    private final MetricSet metrics;
    private volatile ServiceRegistration metricsRegistration;
    private volatile RepositoryContentTypeSupport repositoryContentTypeSupport;

    protected static String createMetricsId(RepositoryProvider repositoryProvider, String repositoryId) {
        return String.valueOf(repositoryProvider.getProviderId()) + "." + repositoryId + ".metrics";
    }

    protected Repository(String repositoryId, RepositoryProvider repositoryProvider, MetricSet metrics) throws IllegalArgumentException {
        if (repositoryId == null) {
            throw new IllegalArgumentException("repository id must not be null");
        }
        if (repositoryProvider == null) {
            throw new IllegalArgumentException("repository provider must not be null");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("metrics must not be null");
        }
        if (!IdHelper.isValidId((String)repositoryId)) {
            throw new IllegalArgumentException(MessageFormat.format("repository id \"{0}\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", repositoryId));
        }
        this.repositoryId = repositoryId;
        this.repositoryProvider = repositoryProvider;
        this.metrics = metrics;
        this.registerMetrics();
    }

    public final void close() {
        this.closed = true;
        try {
            this.doClose();
        }
        finally {
            this.metricsRegistration.unregister();
            this.metricsRegistration = null;
        }
    }

    protected void doClose() {
    }

    public RepositoryContentTypeSupport getContentTypeSupport() {
        if (this.repositoryContentTypeSupport != null) {
            return this.repositoryContentTypeSupport;
        }
        this.repositoryContentTypeSupport = new BasicRepositoryContentTypeSupport(this);
        return this.repositoryContentTypeSupport;
    }

    public String getDescription() {
        return "";
    }

    public RepositoryMetadata getMetadata(String id) {
        RepositoryRegistry registry = PersistenceActivator.getInstance().getRepositoriesManager();
        IRepositoryDefinition definition = registry.getRepositoryDefinition(this.repositoryId);
        if (definition == null) {
            throw new IllegalStateException(String.format("Repository definition not found for repository %s.", this.repositoryId));
        }
        return new RepositoryPreferencesBasedMetadata(definition.getRepositoryPreferences(), id, this.repositoryId);
    }

    protected final MetricSet getMetrics() {
        return this.metrics;
    }

    private String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index != -1) {
            string = string.substring(index + 1, string.length());
        }
        return string;
    }

    public final String getRepositoryId() {
        return this.repositoryId;
    }

    public final RepositoryProvider getRepositoryProvider() {
        return this.repositoryProvider;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    private void registerMetrics() throws IllegalArgumentException, IllegalStateException {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (bundleContext == null) {
            throw new IllegalStateException("Unable to determin bundle context for class '" + this.getClass().getName() + "'. Please ensure that this class was loaded by a bundle which is either STARTING, ACTIVE or STOPPING.");
        }
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", String.valueOf(this.getName()) + "[" + this.getRepositoryId() + "]");
        ((Dictionary)properties).put("service.description", "Metrics for repository '" + this.getRepositoryId() + "'.");
        ((Dictionary)properties).put("gyrex.repository.id", this.getRepositoryId());
        try {
            String description = this.getDescription();
            if (StringUtils.isNotBlank((String)description)) {
                ((Dictionary)properties).put("gyrex.repository.description", description);
            }
        }
        catch (Exception exception) {}
        this.metricsRegistration = bundleContext.registerService(MetricSet.SERVICE_NAME, (Object)this.metrics, properties);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " {" + this.repositoryId + "}";
    }
}

