/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.storage.content;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.osgi.framework.Version;

public final class RepositoryContentType
extends PlatformObject {
    private final String mediaTypeType;
    private final String mediaTypeSubType;
    private final String repositoryTypeName;
    private final Version version;
    private int cachedHashCode;
    private final Map<String, String> parameters;

    private static final String checkMediaTypeSubType(String mediaTypeSubType) throws IllegalArgumentException {
        RepositoryContentType.checkToken(mediaTypeSubType, "media type subtype");
        return mediaTypeSubType;
    }

    private static final String checkMediaTypeType(String mediaTypeType) throws IllegalArgumentException {
        RepositoryContentType.checkToken(mediaTypeType, "media type type");
        return mediaTypeType;
    }

    private static Map<String, String> checkParameters(Map<String, String> parameters) {
        for (String key : parameters.keySet()) {
            RepositoryContentType.checkToken(key, String.format("parameter key '%s'", key));
            String value = parameters.get(key);
            RepositoryContentType.checkToken(value, String.format("parameter value '%s'", value));
        }
        return parameters;
    }

    private static final String checkRepositoryTypeId(String repositoryTypeId) {
        if (repositoryTypeId == null) {
            throw new IllegalArgumentException("repository type name must not be null");
        }
        if (!IdHelper.isValidId((String)repositoryTypeId)) {
            throw new IllegalArgumentException(MessageFormat.format("repository type name \"{0}\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", repositoryTypeId));
        }
        return repositoryTypeId;
    }

    private static void checkToken(String token, String description) {
        char[] cs;
        if (token == null) {
            throw new IllegalArgumentException(String.format("invalid %s; must not be null, see RFC 2045 section 5.1", description));
        }
        char[] cArray = cs = token.toCharArray();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!RepositoryContentType.isUsAsciiChar(c)) {
                throw new IllegalArgumentException(String.format("invalid %s; only US-ASCII chars allowed, see RFC 2045 section 5.1", description));
            }
            if (RepositoryContentType.isControlChar(c)) {
                throw new IllegalArgumentException(String.format("invalid %s; control characters not allowed, see RFC 2045 section 5.1", description));
            }
            if (RepositoryContentType.isWhitespace(c)) {
                throw new IllegalArgumentException(String.format("invalid %s; whitespace not allowed, see RFC 2045 section 5.1", description));
            }
            if (RepositoryContentType.isSpecialChar(c)) {
                throw new IllegalArgumentException(String.format("invalid %s; character '%c' not allowed, see RFC 2045 section 5.1", description, Character.valueOf(c)));
            }
            ++n2;
        }
    }

    private static final boolean isControlChar(char c) {
        return c < ' ' || c == '\u007f';
    }

    private static final boolean isSpecialChar(char c) {
        switch (c) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    private static final boolean isUsAsciiChar(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    private static final boolean isWhitespace(char c) {
        return c == ' ';
    }

    public RepositoryContentType(String mediaTypeType, String mediaTypeSubType, String repositoryTypeName, String version) throws IllegalArgumentException {
        this(mediaTypeType, mediaTypeSubType, repositoryTypeName, version, null);
    }

    public RepositoryContentType(String mediaTypeType, String mediaTypeSubType, String repositoryTypeName, String version, Map<String, String> parameters) throws IllegalArgumentException {
        this.mediaTypeType = RepositoryContentType.checkMediaTypeType(mediaTypeType);
        this.mediaTypeSubType = RepositoryContentType.checkMediaTypeSubType(mediaTypeSubType);
        this.repositoryTypeName = RepositoryContentType.checkRepositoryTypeId(repositoryTypeName);
        this.version = Version.parseVersion((String)version);
        this.parameters = parameters != null ? new LinkedHashMap<String, String>(RepositoryContentType.checkParameters(parameters)) : null;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RepositoryContentType other = (RepositoryContentType)((Object)obj);
        if (this.mediaTypeType == null ? other.mediaTypeType != null : other.mediaTypeType == null || !this.mediaTypeType.toLowerCase(Locale.US).equals(other.mediaTypeType.toLowerCase(Locale.US))) {
            return false;
        }
        if (this.mediaTypeSubType == null ? other.mediaTypeSubType != null : other.mediaTypeSubType == null || !this.mediaTypeSubType.toLowerCase(Locale.US).equals(other.mediaTypeSubType.toLowerCase(Locale.US))) {
            return false;
        }
        if (this.repositoryTypeName == null ? other.repositoryTypeName != null : !this.repositoryTypeName.equals(other.repositoryTypeName)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals((Object)other.version)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : other.parameters == null || !this.parameters.equals(other.parameters));
    }

    public final String getMediaType() {
        return String.format("%s/%s", this.mediaTypeType, this.mediaTypeSubType);
    }

    public String getMediaTypeSubType() {
        return this.mediaTypeSubType;
    }

    public String getMediaTypeType() {
        return this.mediaTypeType;
    }

    public final String getParameter(String name) {
        return this.parameters != null ? this.parameters.get(name) : null;
    }

    public final String getRepositoryTypeName() {
        return this.repositoryTypeName;
    }

    public final String getVersion() {
        return this.version.toString();
    }

    public final int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = 1;
        result = 31 * result + (this.mediaTypeType == null ? 0 : this.mediaTypeType.toLowerCase(Locale.US).hashCode());
        result = 31 * result + (this.mediaTypeSubType == null ? 0 : this.mediaTypeSubType.toLowerCase(Locale.US).hashCode());
        result = 31 * result + (this.repositoryTypeName == null ? 0 : this.repositoryTypeName.hashCode());
        this.cachedHashCode = result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return this.cachedHashCode;
    }

    public final String toString() {
        StringBuilder contentType = new StringBuilder();
        contentType.append(this.getMediaType());
        contentType.append("; repositoryType=\"");
        contentType.append(this.getRepositoryTypeName());
        contentType.append("\"; version=\"");
        contentType.append(this.getVersion());
        contentType.append('\"');
        if (this.parameters != null) {
            for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                contentType.append("; ").append(parameter.getKey()).append("=\"").append(parameter.getValue()).append('\"');
            }
        }
        return contentType.toString();
    }
}

