/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.osgi.service.prefs.Preferences;

public class LsCmd
extends Command {
    @Option(name="-r", aliases={"--recursive"}, required=false, usage="recursively go into child nodes")
    protected boolean recursive = false;
    @Argument(index=0, required=true, usage="path to a preference node")
    protected String path;

    public LsCmd() {
        super("[-r] [<path>] - list preferences");
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        IEclipsePreferences node = preferencesService.getRootNode();
        String[] decodedPath = EclipsePreferencesUtil.decodePath(StringUtils.trimToEmpty((String)this.path));
        Preferences preferencesNode = node.node(StringUtils.trimToEmpty((String)decodedPath[0]));
        if (this.recursive) {
            this.printTree(0, preferencesNode);
        } else if (StringUtils.isNotBlank((String)decodedPath[1])) {
            this.printValue(preferencesNode, decodedPath[1]);
        } else {
            String[] childrenNames;
            String[] keys;
            String[] stringArray = keys = preferencesNode.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.printValue(preferencesNode, key);
                ++n2;
            }
            String[] stringArray2 = childrenNames = preferencesNode.childrenNames();
            int n3 = childrenNames.length;
            n = 0;
            while (n < n3) {
                String child = stringArray2[n];
                this.printChildInfo(0, preferencesNode.node(child));
                ++n;
            }
        }
    }

    private void printChildInfo(int indent, Preferences node) throws Exception {
        String[] children = node.childrenNames();
        StrBuilder spaces = new StrBuilder();
        int i = 0;
        while (i < indent) {
            spaces.append(" ");
            ++i;
        }
        this.printf(spaces.append(node.absolutePath()).append(" (").append(children.length).append(")").toString(), new Object[0]);
    }

    private void printTree(int indent, Preferences node) throws Exception {
        String[] children;
        this.printChildInfo(indent, node);
        String[] stringArray = children = node.childrenNames();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            this.printTree(indent + 1, node.node(child));
            ++n2;
        }
    }

    private void printValue(Preferences preferencesNode, String key) {
        String value = preferencesNode.get(key, null);
        if (value != null) {
            this.printf("%s: %s=%s", new Object[]{preferencesNode.absolutePath(), key, value});
        } else {
            this.printf("%s: %s not set", new Object[]{preferencesNode.absolutePath(), key});
        }
    }
}

