/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.osgi.service.prefs.Preferences;

public class SetCmd
extends Command {
    @Argument(index=0, required=true, metaVar="PATH", usage="path to a preference key")
    String path;
    @Argument(index=1, required=true, metaVar="VALUE", usage="value to set")
    String value;
    @Option(name="-t", aliases={"--type"}, required=false, usage="how to parse the preference value (string, int, boolean, float, double, long)")
    Type type = Type.STRING;

    public SetCmd() {
        super("[-t <type>] <path> <value> - sets a preference");
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        String[] decodedPath = EclipsePreferencesUtil.decodePath(StringUtils.trimToEmpty((String)this.path));
        Preferences node = preferencesService.getRootNode().node(StringUtils.trimToEmpty((String)decodedPath[0]));
        switch (this.type) {
            case INT: {
                node.putInt(decodedPath[1], Integer.parseInt(this.value));
                break;
            }
            case LONG: {
                node.putLong(decodedPath[1], Long.parseLong(this.value));
                break;
            }
            case BOOLEAN: {
                node.putBoolean(decodedPath[1], Boolean.parseBoolean(this.value));
                break;
            }
            case DOUBLE: {
                node.putDouble(decodedPath[1], Double.parseDouble(this.value));
                break;
            }
            case FLOAT: {
                node.putFloat(decodedPath[1], Float.parseFloat(this.value));
                break;
            }
            case STRING: {
                node.put(decodedPath[1], this.value);
                break;
            }
            default: {
                throw new IllegalStateException("unhandled type: " + (Object)((Object)this.type));
            }
        }
        node.flush();
    }

    public static enum Type {
        STRING,
        INT,
        BOOLEAN,
        FLOAT,
        DOUBLE,
        LONG;

    }
}

