/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.util;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.preferences.internal.PreferencesActivator;

public class EclipsePreferencesUtil {
    public static final String PATH_SEPARATOR = String.valueOf('/');
    public static final String DOUBLE_SLASH = "//";
    public static final String EMPTY_STRING = "";

    public static String[] decodePath(String fullPath) {
        String key = null;
        String path = null;
        int index = fullPath.indexOf(DOUBLE_SLASH);
        if (index == -1) {
            int lastIndex = fullPath.lastIndexOf(47);
            if (lastIndex == -1) {
                key = fullPath;
            } else {
                path = fullPath.substring(0, lastIndex);
                key = fullPath.substring(lastIndex + 1);
            }
        } else {
            path = fullPath.substring(0, index);
            key = fullPath.substring(index + 2);
        }
        if (path != null) {
            if (path.length() == 0) {
                path = null;
            } else if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        return new String[]{path, key};
    }

    public static IPreferencesService getPreferencesService() {
        try {
            return PreferencesActivator.getInstance().getPreferencesService();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("The Eclipse preference service is not available. Please verify the server installation and that all necessary bundles are started. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public static IEclipsePreferences getRootNode() {
        return EclipsePreferencesUtil.getPreferencesService().getRootNode();
    }

    public static String makeRelative(String path) {
        String result = path;
        if (path == null) {
            return EMPTY_STRING;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result = path.length() == 1 ? EMPTY_STRING : path.substring(1);
        }
        return result;
    }

    private EclipsePreferencesUtil() {
    }
}

