/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.solr.tests;

import java.util.Arrays;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.model.common.ModelUtil;
import org.eclipse.gyrex.search.ISearchManager;
import org.eclipse.gyrex.search.documents.IDocument;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.query.IQuery;
import org.eclipse.gyrex.search.result.IResult;
import org.eclipse.gyrex.search.solr.tests.BaseSolrTest;
import org.junit.Test;

public class SolrCdsServiceTest
extends BaseSolrTest {
    @Test
    public void test001_CdsBasics() throws Exception {
        ISearchManager docManager = (ISearchManager)ModelUtil.getManager(ISearchManager.class, (IRuntimeContext)this.getContext());
        IFacet colorFacet = docManager.createFacet("color");
        colorFacet.setName("Color");
        docManager.saveFacet(colorFacet);
        IDocument doc1 = docManager.createDocument();
        IDocument doc2 = docManager.createDocument();
        doc1.getOrCreate("color").ofType(String.class).add((Object)"blue");
        doc2.getOrCreate("color").ofType(String.class).add((Object)"red");
        docManager.publishDocuments(Arrays.asList(doc1, doc2));
        SolrCdsServiceTest.waitForPendingSolrPublishOps();
        IQuery query = docManager.createQuery();
        Assert.assertNotNull((Object)query);
        IResult result = docManager.findByQuery(query);
        Assert.assertNotNull((Object)result);
        Map facets = result.getFacets();
        Assert.assertNotNull((Object)facets);
        Assert.assertTrue((String)"facet 'color' is missing", (boolean)facets.containsKey("color"));
    }
}

