/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.documents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.search.documents.IDocumentAttribute;
import org.eclipse.osgi.util.NLS;

public class BaseDocumentAttribute<T>
extends PlatformObject
implements IDocumentAttribute<T> {
    private static Set<Class<?>> allowedTypes;
    private final String id;
    private final List<T> values = new ArrayList<T>(3);

    static {
        HashSet<Class<Date>> classes = new HashSet<Class<Date>>();
        classes.add(String.class);
        classes.add(Boolean.class);
        classes.add(Double.class);
        classes.add(Float.class);
        classes.add(Long.class);
        classes.add(Integer.class);
        classes.add(Date.class);
        allowedTypes = Collections.unmodifiableSet(classes);
    }

    public BaseDocumentAttribute(String id) {
        this.id = id;
    }

    @Override
    public void add(Iterable<T> values) {
        for (T value : values) {
            this.doAdd(value);
        }
    }

    @Override
    public void add(T value) {
        this.doAdd(value);
    }

    @Override
    public void add(T ... values) {
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            this.doAdd(value);
            ++n2;
        }
    }

    @Override
    public void addIfNotPresent(T value) {
        if (!this.values.contains(value)) {
            this.doAdd(value);
        }
    }

    private void checkType(Class<?> type) {
        do {
            if (allowedTypes.contains(type)) {
                return;
            }
            if (type.getSuperclass() == null) {
                throw new IllegalArgumentException(NLS.bind((String)"value type {0} not supported", (Object)type.getName()));
            }
            type = type.getSuperclass();
        } while (Boolean.TRUE.booleanValue());
    }

    private void checkValue(T value) {
        if (value != null) {
            this.checkType(value.getClass());
        }
    }

    private void clearIfNecessary() {
        if (!this.values.isEmpty()) {
            this.doClear();
        }
    }

    @Override
    public boolean contains(T value) {
        return this.values.contains(value);
    }

    protected boolean doAdd(T value) {
        this.checkValue(value);
        return this.values.add(value);
    }

    protected void doClear() {
        this.values.clear();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public T getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public Collection<T> getValues() {
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public <E> IDocumentAttribute<E> ofType(Class<E> type) throws IllegalArgumentException {
        this.checkType(type);
        T value = this.getValue();
        if (value != null && !type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(NLS.bind((String)"value type {0} not assignale to type {1}", (Object)value.getClass().getName(), (Object)type.getName()));
        }
        return this;
    }

    @Override
    public void remove(T value) {
        this.values.remove(value);
    }

    @Override
    public void set(Iterable<T> values) {
        this.clearIfNecessary();
        this.add((T)values);
    }

    @Override
    public void set(T value) {
        this.checkValue(value);
        this.clearIfNecessary();
        if (value != null) {
            this.add(value);
        }
    }

    @Override
    public void set(T ... values) {
        this.clearIfNecessary();
        this.add(values);
    }

    public String toString() {
        return String.valueOf(this.id) + "={" + this.values + "}";
    }
}

