/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.documents;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.gyrex.search.documents.IDocumentAttribute;
import org.eclipse.gyrex.search.internal.solr.documents.BaseDocument;
import org.eclipse.gyrex.search.internal.solr.documents.BaseDocumentAttribute;

public class TransientDocument
extends BaseDocument {
    private final Map<String, IDocumentAttribute<?>> attributes = new LinkedHashMap();

    @Override
    public boolean contains(String attributeId) {
        return this.attributes.containsKey(attributeId);
    }

    @Override
    public IDocumentAttribute<?> get(String attributeId) {
        return this.attributes.get(attributeId);
    }

    @Override
    public Map<String, IDocumentAttribute<?>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public IDocumentAttribute<?> getOrCreate(String attributeId) {
        IDocumentAttribute<?> attribute = this.attributes.get(attributeId);
        if (attribute == null) {
            attribute = new BaseDocumentAttribute(attributeId);
            this.attributes.put(attributeId, attribute);
        }
        return attribute;
    }

    @Override
    public Object getValue(String attributeId) {
        IDocumentAttribute<?> attribute = this.attributes.get(attributeId);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isTransient() {
        return true;
    }

    @Override
    public IDocumentAttribute<?> remove(String attributeId) {
        return this.attributes.remove(attributeId);
    }

    public String toString() {
        return "TransientDocument{" + this.attributes.toString().replace('\n', '|').replace('\r', ' ') + "}";
    }
}

