/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.services.common;

import java.text.MessageFormat;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.services.common.IService;

public final class ServiceUtil {
    public static <M extends IService> M getService(Class<M> serviceType, IRuntimeContext context) throws IllegalArgumentException, IllegalStateException {
        if (serviceType == null) {
            throw new IllegalArgumentException("service type must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        IService service = (IService)context.get(serviceType);
        if (service == null) {
            throw new IllegalStateException(MessageFormat.format("No service implementation available for type ''{0}'' in context ''{1}''", serviceType.getName(), context.getContextPath()));
        }
        return (M)service;
    }

    private ServiceUtil() {
    }
}

