/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class ParameterMapping
extends Expression {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(ParameterMapping.class, "expression", Expression.class, true, false);
    public static final ChildPropertyDescriptor IDENTIFIER_PROPERTY = new ChildPropertyDescriptor(ParameterMapping.class, "identifier", SimpleName.class, true, false);
    public static final SimplePropertyDescriptor DIRECTION_PROPERTY = new SimplePropertyDescriptor(ParameterMapping.class, "direction", String.class, true);
    private static final SimplePropertyDescriptor IS_RESULT_PROPERTY = new SimplePropertyDescriptor(ParameterMapping.class, "isResult", Boolean.TYPE, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private Expression _expression = null;
    private SimpleName _identifier = null;
    private String _direction = null;
    private boolean _isResult = false;

    static {
        ArrayList propertyList = new ArrayList(5);
        ParameterMapping.createPropertyList(ParameterMapping.class, propertyList);
        ParameterMapping.addProperty(EXPRESSION_PROPERTY, propertyList);
        ParameterMapping.addProperty(IDENTIFIER_PROPERTY, propertyList);
        ParameterMapping.addProperty(DIRECTION_PROPERTY, propertyList);
        ParameterMapping.addProperty(IS_RESULT_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = ParameterMapping.reapPropertyList(propertyList);
    }

    ParameterMapping(AST ast) {
        super(ast);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS_2_0;
    }

    List internalStructuralPropertiesForType(int apiLevel) {
        return PROPERTY_DESCRIPTORS_2_0;
    }

    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean isGet, ASTNode child) {
        if (property == IDENTIFIER_PROPERTY) {
            if (isGet) {
                return this.getIdentifier();
            }
            this.setIdentifier((SimpleName)child);
            return null;
        }
        if (property == EXPRESSION_PROPERTY) {
            if (isGet) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, isGet, child);
    }

    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean isGet, boolean value) {
        if (property == IS_RESULT_PROPERTY) {
            if (isGet) {
                return this.hasResultFlag();
            }
            this.setResultFlag(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, isGet, value);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean isGet, Object value) {
        if (property == DIRECTION_PROPERTY) {
            if (isGet) {
                return this.getDirection();
            }
            this.setDirection((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, isGet, value);
    }

    public boolean hasResultFlag() {
        return this._isResult;
    }

    public void setResultFlag(boolean resultFlag) {
        this.preValueChange(IS_RESULT_PROPERTY);
        this._isResult = resultFlag;
        this.postValueChange(IS_RESULT_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getIdentifier() {
        if (this._identifier == null) {
            ParameterMapping parameterMapping = this;
            synchronized (parameterMapping) {
                if (this._identifier == null) {
                    this.preLazyInit();
                    this._identifier = new SimpleName(this.ast);
                    this.postLazyInit(this._identifier, IDENTIFIER_PROPERTY);
                }
            }
        }
        return this._identifier;
    }

    public void setIdentifier(SimpleName identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this._identifier;
        this.preReplaceChild(oldChild, identifier, IDENTIFIER_PROPERTY);
        this._identifier = identifier;
        this.postReplaceChild(oldChild, identifier, IDENTIFIER_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirection() {
        if (this._direction == null) {
            ParameterMapping parameterMapping = this;
            synchronized (parameterMapping) {
                if (this._direction == null) {
                    this._direction = new String("");
                }
            }
        }
        return this._direction;
    }

    public boolean isBindIN() {
        return "<-".equals(this.getDirection());
    }

    public void setDirection(String direction) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this._direction = direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode getExpression() {
        if (this._expression == null) {
            ParameterMapping parameterMapping = this;
            synchronized (parameterMapping) {
                if (this._expression == null) {
                    this.preLazyInit();
                    this._expression = new SimpleName(this.ast);
                    this.postLazyInit(this._expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this._expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this._expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this._expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    int getNodeType0() {
        return 91;
    }

    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    ASTNode clone0(AST target) {
        ParameterMapping result = new ParameterMapping(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        result.setIdentifier((SimpleName)ASTNode.copySubtree(target, this.getIdentifier()));
        result.setDirection(this.getDirection());
        result.setResultFlag(this.hasResultFlag());
        return result;
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.getDirection().equals("->")) {
                this.acceptChild(visitor, this.getExpression());
                this.acceptChild(visitor, this.getIdentifier());
            } else {
                this.acceptChild(visitor, this.getIdentifier());
                this.acceptChild(visitor, this.getExpression());
            }
        }
        visitor.endVisit(this);
    }

    int treeSize() {
        return this.memSize() + this.getExpression().treeSize();
    }

    int memSize() {
        return 56;
    }
}

