/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlameCommand
extends GitCommand<BlameResult> {
    private String path;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator textComparator;
    private ObjectId startCommit;
    private Collection<ObjectId> reverseEndCommits;
    private Boolean followFileRenames;

    public BlameCommand(Repository repo) {
        super(repo);
    }

    public BlameCommand setFilePath(String filePath) {
        this.path = filePath;
        return this;
    }

    public BlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameCommand setTextComparator(RawTextComparator textComparator) {
        this.textComparator = textComparator;
        return this;
    }

    public BlameCommand setStartCommit(AnyObjectId commit) {
        this.startCommit = commit.toObjectId();
        return this;
    }

    public BlameCommand setFollowFileRenames(boolean follow) {
        this.followFileRenames = follow;
        return this;
    }

    public BlameCommand reverse(AnyObjectId start, AnyObjectId end) throws IOException {
        return this.reverse(start, Collections.singleton(end.toObjectId()));
    }

    public BlameCommand reverse(AnyObjectId start, Collection<ObjectId> end) throws IOException {
        this.startCommit = start.toObjectId();
        this.reverseEndCommits = new ArrayList<ObjectId>(end);
        return this;
    }

    @Override
    public BlameResult call() throws JGitInternalException {
        this.checkCallable();
        BlameGenerator gen = new BlameGenerator(this.repo, this.path);
        try {
            Object dc;
            if (this.diffAlgorithm != null) {
                gen.setDiffAlgorithm(this.diffAlgorithm);
            }
            if (this.textComparator != null) {
                gen.setTextComparator(this.textComparator);
            }
            if (this.followFileRenames != null) {
                gen.setFollowFileRenames(this.followFileRenames);
            }
            if (this.reverseEndCommits != null) {
                gen.reverse((AnyObjectId)this.startCommit, this.reverseEndCommits);
            } else if (this.startCommit != null) {
                gen.push(null, this.startCommit);
            } else {
                gen.push(null, this.repo.resolve("HEAD"));
                if (!this.repo.isBare()) {
                    File inTree;
                    dc = this.repo.readDirCache();
                    int entry = ((DirCache)dc).findEntry(this.path);
                    if (0 <= entry) {
                        gen.push(null, ((DirCache)dc).getEntry(entry).getObjectId());
                    }
                    if ((inTree = new File(this.repo.getWorkTree(), this.path)).isFile()) {
                        gen.push(null, new RawText(inTree));
                    }
                }
            }
            dc = gen.computeBlameResult();
            return dc;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            gen.release();
        }
    }
}

