/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class HunkHeader {
    final FileHeader file;
    final int startOffset;
    int endOffset;
    private final OldImage old;
    int newStartLine;
    int newLineCount;
    int nContext;
    private EditList editList;

    HunkHeader(final FileHeader fh, int offset) {
        this(fh, offset, new OldImage(){

            public AbbreviatedObjectId getId() {
                return fh.getOldId();
            }
        });
    }

    HunkHeader(FileHeader fh, int offset, OldImage oi) {
        this.file = fh;
        this.startOffset = offset;
        this.old = oi;
    }

    HunkHeader(FileHeader fh, EditList editList) {
        this(fh, fh.buf.length);
        this.editList = editList;
        this.endOffset = this.startOffset;
        this.nContext = 0;
        if (editList.isEmpty()) {
            this.newStartLine = 0;
            this.newLineCount = 0;
        } else {
            this.newStartLine = ((Edit)editList.get(0)).getBeginB();
            Edit last = (Edit)editList.get(editList.size() - 1);
            this.newLineCount = last.getEndB() - this.newStartLine;
        }
    }

    public FileHeader getFileHeader() {
        return this.file;
    }

    public byte[] getBuffer() {
        return this.file.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public OldImage getOldImage() {
        return this.old;
    }

    public int getNewStartLine() {
        return this.newStartLine;
    }

    public int getNewLineCount() {
        return this.newLineCount;
    }

    public int getLinesContext() {
        return this.nContext;
    }

    public EditList toEditList() {
        if (this.editList == null) {
            this.editList = new EditList();
            byte[] buf = this.file.buf;
            int c = RawParseUtils.nextLF(buf, this.startOffset);
            int oLine = this.old.startLine;
            int nLine = this.newStartLine;
            Edit in = null;
            block6: while (c < this.endOffset) {
                switch (buf[c]) {
                    case 10: 
                    case 32: {
                        in = null;
                        ++oLine;
                        ++nLine;
                        break;
                    }
                    case 45: {
                        if (in == null) {
                            in = new Edit(oLine - 1, nLine - 1);
                            this.editList.add(in);
                        }
                        ++oLine;
                        in.extendA();
                        break;
                    }
                    case 43: {
                        if (in == null) {
                            in = new Edit(oLine - 1, nLine - 1);
                            this.editList.add(in);
                        }
                        ++nLine;
                        in.extendB();
                        break;
                    }
                    case 92: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                c = RawParseUtils.nextLF(buf, c);
            }
        }
        return this.editList;
    }

    void parseHeader() {
        byte[] buf = this.file.buf;
        MutableInteger ptr = new MutableInteger();
        ptr.value = RawParseUtils.nextLF(buf, this.startOffset, ' ');
        this.old.startLine = -RawParseUtils.parseBase10(buf, ptr.value, ptr);
        this.old.lineCount = buf[ptr.value] == 44 ? RawParseUtils.parseBase10(buf, ptr.value + 1, ptr) : 1;
        this.newStartLine = RawParseUtils.parseBase10(buf, ptr.value + 1, ptr);
        this.newLineCount = buf[ptr.value] == 44 ? RawParseUtils.parseBase10(buf, ptr.value + 1, ptr) : 1;
    }

    int parseBody(Patch script, int end) {
        int c;
        byte[] buf = this.file.buf;
        int last = c = RawParseUtils.nextLF(buf, this.startOffset);
        this.old.nDeleted = 0;
        this.old.nAdded = 0;
        block6: while (c < end) {
            switch (buf[c]) {
                case 10: 
                case 32: {
                    ++this.nContext;
                    break;
                }
                case 45: {
                    ++this.old.nDeleted;
                    break;
                }
                case 43: {
                    ++this.old.nAdded;
                    break;
                }
                case 92: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            last = c;
            c = RawParseUtils.nextLF(buf, c);
        }
        if (last < end && this.nContext + this.old.nDeleted - 1 == this.old.lineCount && this.nContext + this.old.nAdded == this.newLineCount && RawParseUtils.match(buf, last, Patch.SIG_FOOTER) >= 0) {
            --this.old.nDeleted;
            return last;
        }
        if (this.nContext + this.old.nDeleted < this.old.lineCount) {
            int missingCount = this.old.lineCount - (this.nContext + this.old.nDeleted);
            script.error(buf, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkOldLinesMissing, missingCount));
        } else if (this.nContext + this.old.nAdded < this.newLineCount) {
            int missingCount = this.newLineCount - (this.nContext + this.old.nAdded);
            script.error(buf, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkNewLinesMissing, missingCount));
        } else if (this.nContext + this.old.nDeleted > this.old.lineCount || this.nContext + this.old.nAdded > this.newLineCount) {
            String oldcnt = this.old.lineCount + ":" + this.newLineCount;
            String newcnt = this.nContext + this.old.nDeleted + ":" + (this.nContext + this.old.nAdded);
            script.warn(buf, this.startOffset, MessageFormat.format(JGitText.get().hunkHeaderDoesNotMatchBodyLineCountOf, oldcnt, newcnt));
        }
        return c;
    }

    void extractFileLines(OutputStream[] out) throws IOException {
        byte[] buf = this.file.buf;
        int ptr = this.startOffset;
        int eol = RawParseUtils.nextLF(buf, ptr);
        if (this.endOffset <= eol) {
            return;
        }
        out[0].write(buf, ptr, eol - ptr);
        ptr = eol;
        block5: while (ptr < this.endOffset) {
            eol = RawParseUtils.nextLF(buf, ptr);
            switch (buf[ptr]) {
                case 10: 
                case 32: 
                case 92: {
                    out[0].write(buf, ptr, eol - ptr);
                    out[1].write(buf, ptr, eol - ptr);
                    break;
                }
                case 45: {
                    out[0].write(buf, ptr, eol - ptr);
                    break;
                }
                case 43: {
                    out[1].write(buf, ptr, eol - ptr);
                    break;
                }
                default: {
                    break block5;
                }
            }
            ptr = eol;
        }
    }

    void extractFileLines(StringBuilder sb, String[] text, int[] offsets) {
        byte[] buf = this.file.buf;
        int ptr = this.startOffset;
        int eol = RawParseUtils.nextLF(buf, ptr);
        if (this.endOffset <= eol) {
            return;
        }
        this.copyLine(sb, text, offsets, 0);
        ptr = eol;
        block5: while (ptr < this.endOffset) {
            eol = RawParseUtils.nextLF(buf, ptr);
            switch (buf[ptr]) {
                case 10: 
                case 32: 
                case 92: {
                    this.copyLine(sb, text, offsets, 0);
                    this.skipLine(text, offsets, 1);
                    break;
                }
                case 45: {
                    this.copyLine(sb, text, offsets, 0);
                    break;
                }
                case 43: {
                    this.copyLine(sb, text, offsets, 1);
                    break;
                }
                default: {
                    break block5;
                }
            }
            ptr = eol;
        }
    }

    void copyLine(StringBuilder sb, String[] text, int[] offsets, int fileIdx) {
        String s = text[fileIdx];
        int start = offsets[fileIdx];
        int end = s.indexOf(10, start);
        end = end < 0 ? s.length() : ++end;
        sb.append(s, start, end);
        offsets[fileIdx] = end;
    }

    void skipLine(String[] text, int[] offsets, int fileIdx) {
        String s = text[fileIdx];
        int end = s.indexOf(10, offsets[fileIdx]);
        offsets[fileIdx] = end < 0 ? s.length() : end + 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("HunkHeader[");
        buf.append(this.getOldImage().getStartLine());
        buf.append(',');
        buf.append(this.getOldImage().getLineCount());
        buf.append("->");
        buf.append(this.getNewStartLine()).append(',').append(this.getNewLineCount());
        buf.append(']');
        return buf.toString();
    }

    public static abstract class OldImage {
        int startLine;
        int lineCount;
        int nDeleted;
        int nAdded;

        public int getStartLine() {
            return this.startLine;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public int getLinesDeleted() {
            return this.nDeleted;
        }

        public int getLinesAdded() {
            return this.nAdded;
        }

        public abstract AbbreviatedObjectId getId();
    }
}

