/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.storage.pack.PackWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsPackDescription
implements Comparable<DfsPackDescription> {
    private final DfsRepositoryDescription repoDesc;
    private final String packName;
    private long lastModified;
    private long packSize;
    private long indexSize;
    private long objectCount;
    private long deltaCount;
    private Set<ObjectId> tips;
    private PackWriter.Statistics stats;

    public DfsPackDescription(DfsRepositoryDescription repoDesc, String name) {
        this.repoDesc = repoDesc;
        this.packName = name;
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getIndexName() {
        String name = this.getPackName();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            dot = name.length();
        }
        return name.substring(0, dot) + ".idx";
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public DfsPackDescription setLastModified(long timeMillis) {
        this.lastModified = timeMillis;
        return this;
    }

    public long getPackSize() {
        return this.packSize;
    }

    public DfsPackDescription setPackSize(long bytes) {
        this.packSize = Math.max(0L, bytes);
        return this;
    }

    public long getIndexSize() {
        return this.indexSize;
    }

    public DfsPackDescription setIndexSize(long bytes) {
        this.indexSize = Math.max(0L, bytes);
        return this;
    }

    public int getReverseIndexSize() {
        return (int)Math.min(this.objectCount * 8L, Integer.MAX_VALUE);
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public DfsPackDescription setObjectCount(long cnt) {
        this.objectCount = Math.max(0L, cnt);
        return this;
    }

    public long getDeltaCount() {
        return this.deltaCount;
    }

    public DfsPackDescription setDeltaCount(long cnt) {
        this.deltaCount = Math.max(0L, cnt);
        return this;
    }

    public Set<ObjectId> getTips() {
        return this.tips;
    }

    public DfsPackDescription setTips(Set<ObjectId> tips) {
        this.tips = tips;
        return this;
    }

    public PackWriter.Statistics getPackStats() {
        return this.stats;
    }

    DfsPackDescription setPackStats(PackWriter.Statistics stats) {
        this.stats = stats;
        return this;
    }

    public DfsPackDescription clearPackStats() {
        this.stats = null;
        return this;
    }

    public int hashCode() {
        return this.getPackName().hashCode();
    }

    public boolean equals(Object b) {
        if (b instanceof DfsPackDescription) {
            DfsPackDescription desc = (DfsPackDescription)b;
            return this.getPackName().equals(desc.getPackName()) && this.getRepositoryDescription().equals(desc.getRepositoryDescription());
        }
        return false;
    }

    @Override
    public int compareTo(DfsPackDescription b) {
        int cmp = Long.signum(b.getLastModified() - this.getLastModified());
        if (cmp != 0) {
            return cmp;
        }
        return Long.signum(this.getObjectCount() - b.getObjectCount());
    }

    public String toString() {
        return this.getPackName();
    }
}

