/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.JGitText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private static final char[] LC;

    public static char toLowerCase(char c) {
        return c <= 'Z' ? LC[c] : c;
    }

    public static String toLowerCase(String in) {
        StringBuilder r = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            r.append(StringUtils.toLowerCase(in.charAt(i)));
        }
        return r.toString();
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (StringUtils.toLowerCase(a.charAt(i)) == StringUtils.toLowerCase(b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean toBoolean(String stringValue) {
        if (stringValue == null) {
            throw new NullPointerException(JGitText.get().expectedBooleanStringValue);
        }
        Boolean bool = StringUtils.toBooleanOrNull(stringValue);
        if (bool == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notABoolean, stringValue));
        }
        return bool;
    }

    public static Boolean toBooleanOrNull(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase("yes", stringValue) || StringUtils.equalsIgnoreCase("true", stringValue) || StringUtils.equalsIgnoreCase("1", stringValue) || StringUtils.equalsIgnoreCase("on", stringValue)) {
            return Boolean.TRUE;
        }
        if (StringUtils.equalsIgnoreCase("no", stringValue) || StringUtils.equalsIgnoreCase("false", stringValue) || StringUtils.equalsIgnoreCase("0", stringValue) || StringUtils.equalsIgnoreCase("off", stringValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String join(Collection<String> parts, String separator) {
        return StringUtils.join(parts, separator, separator);
    }

    public static String join(Collection<String> parts, String separator, String lastSeparator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int lastIndex = parts.size() - 1;
        for (String part : parts) {
            sb.append(part);
            if (i == lastIndex - 1) {
                sb.append(lastSeparator);
            } else if (i != lastIndex) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    private StringUtils() {
    }

    public static boolean isEmptyOrNull(String stringValue) {
        return stringValue == null || stringValue.length() == 0;
    }

    static {
        int c;
        LC = new char[91];
        for (c = 0; c < LC.length; c = (int)((char)(c + 1))) {
            StringUtils.LC[c] = c;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            StringUtils.LC[c] = (char)(97 + (c - 65));
        }
    }
}

