/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.SimpleJavaResourceLocator;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ModuleResourceLocator
extends SimpleJavaResourceLocator {
    public IContainer getDefaultResourceLocation(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        return component.getRootFolder().getFolder(META_INF_PATH).getUnderlyingFolder();
    }

    public IPath getResourcePath(IProject project, IPath runtimePath) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        return component.getRootFolder().getFile(runtimePath).getWorkspaceRelativePath();
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IFile file = PlatformTools.getFile(resourcePath);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder root = component.getRootFolder();
        IVirtualFile vFile = this.findVirtualFile(root, file);
        if (vFile != null) {
            return vFile.getRuntimePath().makeRelative();
        }
        return super.getRuntimePath(project, resourcePath);
    }

    private IVirtualFile findVirtualFile(IVirtualFolder vFolder, IFile file) {
        try {
            IVirtualResource[] iVirtualResourceArray = vFolder.members();
            int n = iVirtualResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualFile vFile;
                IVirtualResource vResource = iVirtualResourceArray[n2];
                if (vResource.getType() == 16 ? file.equals((Object)(vFile = (IVirtualFile)vResource).getUnderlyingResource()) : vResource.getType() == 32 && (vFile = this.findVirtualFile((IVirtualFolder)vResource, file)) != null) {
                    return vFile;
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            JptCommonCorePlugin.log(ce);
        }
        return null;
    }
}

