/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;

public class SimpleJavaResourceLocator
implements ResourceLocator {
    protected static IPath META_INF_PATH = new Path("META-INF");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acceptResourceLocation(IProject project, IContainer container) {
        IJavaProject javaProject = this.getJavaProject(project);
        if (javaProject.isOnClasspath((IResource)container)) {
            return true;
        }
        try {
            IPath outputLocation = javaProject.getOutputLocation();
            if (container.equals((Object)project) && outputLocation.isPrefixOf(container.getFullPath())) {
                return true;
            }
            Object[] objectArray = javaProject.getNonJavaResources();
            int n = objectArray.length;
            int n2 = 0;
            while (true) {
                IFolder folder;
                if (n2 >= n) {
                    return false;
                }
                Object resource = objectArray[n2];
                if (resource instanceof IFolder && ((folder = (IFolder)resource).equals((Object)container) || folder.contains((ISchedulingRule)container)) && !outputLocation.isPrefixOf(container.getFullPath())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JptCommonCorePlugin.log(jme);
        }
        return false;
    }

    public IContainer getDefaultResourceLocation(IProject project) {
        IJavaProject javaProject = this.getJavaProject(project);
        IFolder defaultLocation = null;
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    IContainer rootContainer = (IContainer)root.getUnderlyingResource();
                    IFolder metaInfFolder = rootContainer.getFolder(META_INF_PATH);
                    if (metaInfFolder.exists()) {
                        return metaInfFolder;
                    }
                    if (defaultLocation == null) {
                        defaultLocation = metaInfFolder;
                    }
                }
                ++n2;
            }
            IFolder metaInfFolder = project.getFolder(META_INF_PATH);
            if (metaInfFolder.exists()) {
                return metaInfFolder;
            }
        }
        catch (JavaModelException jme) {
            JptCommonCorePlugin.log(jme);
        }
        return defaultLocation;
    }

    public IPath getResourcePath(IProject project, IPath runtimePath) {
        IJavaProject javaProject = this.getJavaProject(project);
        IPath firstResourcePath = null;
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    IFile file;
                    IContainer rootContainer = (IContainer)root.getUnderlyingResource();
                    IPath resourcePath = rootContainer.getFullPath().append(runtimePath);
                    if (firstResourcePath == null) {
                        firstResourcePath = resourcePath;
                    }
                    if ((file = project.getWorkspace().getRoot().getFile(resourcePath)).exists()) {
                        return file.getFullPath();
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JptCommonCorePlugin.log(jme);
            return null;
        }
        return firstResourcePath;
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IJavaProject javaProject = this.getJavaProject(project);
        IFile file = PlatformTools.getFile(resourcePath);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer rootContainer;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1 && (rootContainer = (IContainer)root.getUnderlyingResource()).contains((ISchedulingRule)file)) {
                    return resourcePath.makeRelativeTo(rootContainer.getFullPath());
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JptCommonCorePlugin.log(jme);
        }
        return resourcePath.makeRelativeTo(project.getFullPath());
    }

    private IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }
}

