/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

public final class BitTools {
    public static boolean flagIsSet(int flags, int flagToCheck) {
        return BitTools.allFlagsAreSet(flags, flagToCheck);
    }

    public static boolean flagIsOff(int flags, int flagToCheck) {
        return BitTools.allFlagsAreOff(flags, flagToCheck);
    }

    public static boolean onlyFlagIsSet(int flags, int flagToCheck) {
        return BitTools.onlyFlagsAreSet(flags, flagToCheck);
    }

    public static boolean onlyFlagIsOff(int flags, int flagToCheck) {
        return BitTools.onlyFlagsAreOff(flags, flagToCheck);
    }

    public static boolean allFlagsAreSet(int flags, int flagsToCheck) {
        return (flags & flagsToCheck) == flagsToCheck;
    }

    public static boolean allFlagsAreOff(int flags, int flagsToCheck) {
        return (flags & flagsToCheck) == 0;
    }

    public static boolean onlyFlagsAreSet(int flags, int flagsToCheck) {
        return BitTools.allFlagsAreSet(flags, flagsToCheck) && BitTools.allFlagsAreOff(flags, ~flagsToCheck);
    }

    public static boolean onlyFlagsAreOff(int flags, int flagsToCheck) {
        return BitTools.allFlagsAreOff(flags, flagsToCheck) && BitTools.allFlagsAreSet(flags, ~flagsToCheck);
    }

    public static boolean anyFlagsAreSet(int flags, int flagsToCheck) {
        return (flags & flagsToCheck) != 0;
    }

    public static boolean anyFlagsAreOff(int flags, int flagsToCheck) {
        return (flags & flagsToCheck) != flagsToCheck;
    }

    public static boolean allFlagsAreSet(int flags, int ... flagsToCheck) {
        int i = flagsToCheck.length;
        while (i-- > 0) {
            if (BitTools.allFlagsAreSet(flags, flagsToCheck[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allFlagsAreOff(int flags, int ... flagsToCheck) {
        int i = flagsToCheck.length;
        while (i-- > 0) {
            if (BitTools.allFlagsAreOff(flags, flagsToCheck[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean onlyFlagsAreSet(int flags, int ... flagsToCheck) {
        int combinedFlags = BitTools.orFlags(flagsToCheck);
        return BitTools.allFlagsAreSet(flags, combinedFlags) && BitTools.allFlagsAreOff(flags, ~combinedFlags);
    }

    public static boolean onlyFlagsAreOff(int flags, int ... flagsToCheck) {
        int combinedFlags = BitTools.orFlags(flagsToCheck);
        return BitTools.allFlagsAreOff(flags, combinedFlags) && BitTools.allFlagsAreSet(flags, ~combinedFlags);
    }

    public static boolean anyFlagsAreSet(int flags, int ... flagsToCheck) {
        int i = flagsToCheck.length;
        while (i-- > 0) {
            if (!BitTools.anyFlagsAreSet(flags, flagsToCheck[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean anyFlagsAreOff(int flags, int ... flagsToCheck) {
        int i = flagsToCheck.length;
        while (i-- > 0) {
            if (!BitTools.anyFlagsAreOff(flags, flagsToCheck[i])) continue;
            return true;
        }
        return false;
    }

    public static int orFlags(int ... flags) {
        int last = flags.length - 1;
        int result = flags[last];
        int i = last;
        while (i-- > 0) {
            result |= flags[i];
        }
        return result;
    }

    public static int andFlags(int ... flags) {
        int last = flags.length - 1;
        int result = flags[last];
        int i = last;
        while (i-- > 0) {
            result &= flags[i];
        }
        return result;
    }

    public static int xorFlags(int ... flags) {
        int last = flags.length - 1;
        int result = flags[last];
        int i = last;
        while (i-- > 0) {
            result ^= flags[i];
        }
        return result;
    }

    private BitTools() {
        throw new UnsupportedOperationException();
    }
}

